<?php
header('Content-Type: application/json');
require 'db.php'; // Your PDO connection ($pdo)

try {
    $stmt = $pdo->query("SELECT username, points, level FROM users ORDER BY points DESC LIMIT 50");
    $leaderboard = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode([
        'success' => true,
        'leaderboard' => $leaderboard
    ]);
} catch (PDOException $e) {
    echo json_encode([
        'success' => false,
        'error' => 'Database error: ' . $e->getMessage()
    ]);
}
