<?php
session_start();
header('Content-Type: application/json');
require 'db.php';

if (!isset($_SESSION['username'])) {
    echo json_encode(['success' => false, 'error' => 'User not logged in.']);
    exit;
}

$username = $_SESSION['username'];
$points = intval($_POST['points'] ?? 0);
$level = intval($_POST['level'] ?? 1);

try {
    $stmt = $pdo->prepare("UPDATE users SET points = ?, level = ? WHERE username = ?");
    $stmt->execute([$points, $level, $username]);

    echo json_encode(['success' => true]);
} catch (Exception $e) {
    echo json_encode(['success' => false, 'error' => 'Failed to update.']);
}
