<?php
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../includes/functions.php';
if(empty($_SESSION['admin_logged_in'])) { header('Location: '.BASE_URL.'/admin/login.php'); exit; }

$pdo = getPDO();

if($_SERVER['REQUEST_METHOD'] === 'POST'){
    $title = trim($_POST['title']);
    $description = trim($_POST['description']);
    $location = trim($_POST['location']);
    $event_date = $_POST['event_date'];
    $ticket_types = $_POST['ticket_types'] ?? [];
    
    // Collect per-type prices
    $ticket_prices = [];
    foreach($ticket_types as $type){
        $field = 'price_'.str_replace(' ','',$type);
        $ticket_prices[$type] = floatval($_POST[$field] ?? 0);
    }
    $ticket_prices_json = json_encode($ticket_prices);
    
    // Handle logo upload
    $logo_path = null;
    if(isset($_FILES['logo']) && $_FILES['logo']['error'] === 0){
        $ext = pathinfo($_FILES['logo']['name'], PATHINFO_EXTENSION);
        $logo_path = 'uploads/'.uniqid().'.'.$ext;
        move_uploaded_file($_FILES['logo']['tmp_name'], __DIR__.'/../public/'.$logo_path);
    }

    $stmt = $pdo->prepare("INSERT INTO events (title, description, location, event_date, ticket_types, ticket_prices, logo_path) VALUES (?,?,?,?,?,?,?)");
    $stmt->execute([$title,$description,$location,$event_date,implode(',',$ticket_types),$ticket_prices_json,$logo_path]);
    header('Location: '.BASE_URL.'/admin/dashboard.php'); exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
<title>Add Event - Admin</title>
<style>
/* ================= GLOBAL RESET ================= */
* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
    font-family: 'Poppins', sans-serif;
}

body {
    background: #f5f7fb;
    color: #222;
    overflow-x: hidden;
}

/* ================= ADD-EVENT FORM ================= */
.admin-form {
    max-width: 800px;
    margin: 50px auto;
    background: #fff;
    padding: 30px 35px;
    border-radius: 14px;
    box-shadow: 0 6px 25px rgba(0,0,0,0.12);
}

.admin-form h2 {
    font-size: 28px;
    margin-bottom: 25px;
    color: #00eaff;
    text-align: center;
}

.admin-form label {
    display: flex;
    flex-direction: column;
    font-weight: 500;
    margin-bottom: 15px;
    color: #111;
}

.admin-form input[type="text"],
.admin-form input[type="datetime-local"],
.admin-form input[type="number"],
.admin-form textarea,
.admin-form select {
    width: 100%;
    padding: 12px 14px;
    border-radius: 8px;
    border: 1px solid #ccc;
    font-size: 16px; /* Prevent zoom on mobile */
    margin-top: 6px;
    transition: 0.2s ease;
}

.admin-form input:focus,
.admin-form textarea:focus,
.admin-form select:focus {
    border-color: #00eaff;
    outline: none;
    box-shadow: 0 0 6px rgba(0,234,255,0.3);
}

.admin-form textarea {
    min-height: 100px;
    resize: vertical;
}

.admin-form .ticket-type {
    display: flex;
    flex-wrap: wrap;
    gap: 20px;
    margin-bottom: 20px;
}

.admin-form .ticket-type label {
    flex: 1 1 250px;
    font-weight: 500;
}

.admin-form .ticket-type input[type="number"] {
    width: 100px;
    margin-left: 8px;
}

.admin-form input[type="file"] {
    margin-top: 10px;
}

.admin-form button {
    background: #00eaff;
    color: #000;
    font-weight: 600;
    padding: 12px 25px;
    border: none;
    border-radius: 10px;
    cursor: pointer;
    font-size: 16px;
    transition: 0.3s ease;
}

.admin-form button:hover {
    background: #00bcd4;
    color: #fff;
}

/* =============== RESPONSIVE ================= */
@media (max-width: 768px) {
    .admin-form {
        padding: 20px 20px;
    }

    .admin-form .ticket-type {
        flex-direction: column;
    }

    .admin-form .ticket-type input[type="number"] {
        width: 100%;
        margin-left: 0;
        margin-top: 5px;
    }
}
</style>
</head>
<body>

<form class="admin-form" method="post" enctype="multipart/form-data">
  <h2>Add New Event</h2>
  <label>
    Event Title
    <input type="text" name="title" placeholder="Event Title" required>
  </label>
  <label>
    Event Description
    <textarea name="description" placeholder="Event Description"></textarea>
  </label>
  <label>
    Location
    <input type="text" name="location" placeholder="Location">
  </label>
  <label>
    Event Date & Time
    <input type="datetime-local" name="event_date" required>
  </label>

  <h4>Ticket Types</h4>
  <div class="ticket-type">
  <?php 
  $types=['Regular','VIP','Family of 5']; 
  foreach($types as $t): ?>
    <label>
      <input type="checkbox" name="ticket_types[]" value="<?=$t?>"> <?=$t?> Price:
      <input type="number" step="0.01" name="price_<?=str_replace(' ','',$t)?>" value="0">
    </label>
  <?php endforeach; ?>
  </div>

  <label>
    Event Logo
    <input type="file" name="logo" accept="image/*">
  </label>

  <button type="submit">Add Event</button>
</form>

</body>
</html>
