<?php
require_once __DIR__ . '/../config.php';
if (empty($_SESSION['admin_logged_in'])) { 
    header('Location: ' . BASE_URL . '/admin/login.php'); 
    exit; 
}

$pdo = getPDO();

// Fetch events
$stmt = $pdo->query("SELECT * FROM events ORDER BY event_date DESC");
$events = $stmt->fetchAll();

// Fetch tickets for all events
$ticketsStmt = $pdo->query("
    SELECT t.*, e.title AS event_title 
    FROM tickets t 
    JOIN events e ON t.event_id = e.id
    ORDER BY t.purchased_at DESC
");
$tickets = $ticketsStmt->fetchAll();
?>
<!doctype html>
<html>
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Admin Dashboard</title>
<link rel="stylesheet" href="<?=BASE_URL?>/assets/css/style.css">
<style>
body { font-family: Arial, sans-serif; background: #f2f4f7; margin: 0; padding: 0; }
.container { max-width: 1200px; margin: 20px auto; padding: 0 15px; }
.card { background: #fff; padding: 20px; border-radius: 10px; box-shadow: 0 3px 8px rgba(0,0,0,0.1); margin-bottom: 30px; }
h2, h3 { margin-top: 0; }
table { width: 100%; border-collapse: collapse; margin-top: 10px; overflow-x:auto; display:block; }
th, td { border: 1px solid #ddd; padding: 8px; text-align: left; white-space: nowrap; }
th { background: #007BFF; color: #fff; }
tr.used { background: #f8d7da; }
tr.unused { background: #d4edda; }
.search-box { margin-bottom: 20px; }
.search-box input, .search-box select { padding: 6px; width: 250px; margin-right: 6px; border-radius:4px; border:1px solid #ccc; }
.btn { padding: 5px 10px; margin:2px; background:#007BFF; color:#fff; text-decoration:none; border-radius:4px; font-size:14px; }
.btn:hover { background:#0056b3; }
@media (max-width: 768px) {
    table { display:block; overflow-x:auto; }
    th, td { white-space: nowrap; }
}
img { max-width: 60px; border-radius: 4px; }
</style>
</head>
<body>
<main class="container">
<div class="card">
    <h2>Admin Dashboard</h2>
    <p>Welcome, <?=htmlspecialchars($_SESSION['admin_user'])?> — 
       <a class="btn" href="<?=BASE_URL?>/admin/logout.php">Logout</a> | 
       <a class="btn" href="<?=BASE_URL?>/admin/add_event.php">Add Event</a> | 
       <a class="btn" href="<?=BASE_URL?>/admin/scan.php">Open QR Scanner</a>
    </p>

    <!-- Filter/Search -->
    <div class="search-box">
        <label>Filter Tickets: </label>
        <input type="text" id="ticketSearch" placeholder="Name or Token">
        <select id="eventFilter">
            <option value="">All Events</option>
            <?php foreach($events as $e): ?>
                <option value="<?=htmlspecialchars($e['title'])?>"><?=htmlspecialchars($e['title'])?></option>
            <?php endforeach; ?>
        </select>
    </div>

    <!-- Tickets Table -->
    <table id="ticketsTable">
        <thead>
            <tr>
                <th>ID</th>
                <th>Event</th>
                <th>Name</th>
                <th>Email</th>
                <th>Type</th>
                <th>Status</th>
                <th>Purchased At</th>
                <th>QR</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach($tickets as $t): ?>
            <tr class="<?=($t['status']==='used')?'used':'unused'?>">
                <td><?=intval($t['id'])?></td>
                <td><?=htmlspecialchars($t['event_title'])?></td>
                <td><?=htmlspecialchars($t['buyer_name'])?></td>
                <td><?=htmlspecialchars($t['buyer_email'])?></td>
                <td><?=htmlspecialchars($t['ticket_type'])?></td>
                <td><?=htmlspecialchars($t['status'])?></td>
                <td><?=htmlspecialchars($t['purchased_at'])?></td>
                <td>
                    <?php if($t['qr_path'] && file_exists(__DIR__ . '/../' . $t['qr_path'])): ?>
                        <img src="<?=BASE_URL?>/<?=htmlspecialchars($t['qr_path'])?>" alt="QR">
                    <?php else: ?>
                        N/A
                    <?php endif; ?>
                </td>
                <td>
                    <?php if($t['status']==='unused'): ?>
                        <a class="btn" href="<?=BASE_URL?>/admin/mark_used.php?ticket_id=<?=intval($t['id'])?>">Mark Used</a>
                    <?php else: ?>
                        <a class="btn" href="<?=BASE_URL?>/admin/undo_used.php?ticket_id=<?=intval($t['id'])?>">Undo</a>
                    <?php endif; ?>
                    <a class="btn" href="<?=BASE_URL?>/admin/download_ticket.php?ticket_id=<?=intval($t['id'])?>" target="_blank">PDF</a>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>

    <!-- Events Table -->
    <h3>All Events</h3>
    <table>
      <thead>
        <tr>
          <th>ID</th>
          <th>Title</th>
          <th>Date</th>
          <th>Ticket Types</th>
          <th>Logo</th>
          <th>Actions</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach($events as $e): ?>
        <tr>
          <td><?=intval($e['id'])?></td>
          <td><?=htmlspecialchars($e['title'])?></td>
          <td><?=htmlspecialchars($e['event_date'])?></td>
          <td><?=htmlspecialchars($e['ticket_types'])?></td>
          <td>
            <?php if($e['logo_path'] && file_exists(__DIR__ . '/../' . $e['logo_path'])): ?>
              <img src="<?=BASE_URL?>/<?=htmlspecialchars($e['logo_path'])?>" alt="Logo">
            <?php else: ?>
              N/A
            <?php endif; ?>
          </td>
          <td>
            <a class="btn" href="<?=BASE_URL?>/admin/delete_event.php?id=<?=intval($e['id'])?>" onclick="return confirm('Delete this event?')">Delete</a>
          </td>
        </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
</div>
</main>

<script>
// Filter tickets by search input and event dropdown
const searchInput = document.getElementById('ticketSearch');
const eventFilter = document.getElementById('eventFilter');
const ticketsTable = document.getElementById('ticketsTable').getElementsByTagName('tbody')[0];

function filterTickets() {
    const search = searchInput.value.toLowerCase();
    const event = eventFilter.value.toLowerCase();
    const rows = ticketsTable.getElementsByTagName('tr');
    Array.from(rows).forEach(row => {
        const text = row.textContent.toLowerCase();
        const eventText = row.cells[1].textContent.toLowerCase();
        const show = text.includes(search) && (event === "" || eventText === event);
        row.style.display = show ? "" : "none";
    });
}

searchInput.addEventListener('keyup', filterTickets);
eventFilter.addEventListener('change', filterTickets);
</script>
</body>
</html>
