<?php
require_once __DIR__ . '/../config.php';
if (empty($_SESSION['admin_logged_in'])) {
    header('Location: ' . BASE_URL . '/admin/login.php');
    exit;
}

$pdo = getPDO();
$event_id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
if (!$event_id) {
    header('Location: ' . BASE_URL . '/admin/dashboard.php');
    exit;
}

// Get logo path to delete file
$stmt = $pdo->prepare("SELECT logo_path FROM events WHERE id=?");
$stmt->execute([$event_id]);
$event = $stmt->fetch();
if ($event && $event['logo_path']) {
    $file = __DIR__ . '/../' . $event['logo_path'];
    if (file_exists($file)) unlink($file);
}

// Delete event record
$del = $pdo->prepare("DELETE FROM events WHERE id=?");
$del->execute([$event_id]);

header('Location: ' . BASE_URL . '/admin/dashboard.php');
exit;
