<?php
require_once __DIR__ . '/../config.php';
$pdo = getPDO();
$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';
    if ($username && $password) {
        $stmt = $pdo->prepare("SELECT * FROM admin_users WHERE username = ?");
        $stmt->execute([$username]);
        $user = $stmt->fetch();
        if ($user && password_verify($password, $user['password_hash'])) {
            $_SESSION['admin_logged_in'] = true;
            $_SESSION['admin_user'] = $user['username'];
            header('Location: ' . BASE_URL . '/admin/dashboard.php'); exit;
        } else { $error = 'Invalid credentials'; }
    } else { $error = 'Enter username & password'; }
}
?>
<!doctype html>
<html><head><meta charset="utf-8"><title>Admin Login</title>
<link rel="stylesheet" href="<?=BASE_URL?>/assets/css/style.css"></head>
<body>
<main class="container">
  <div class="card">
    <h2>Admin Login</h2>
    <?php if ($error): ?><div class="alert"><?=htmlspecialchars($error)?></div><?php endif; ?>
    <form method="post">
      <div class="form-row"><label>Username</label><input name="username" required></div>
      <div class="form-row"><label>Password</label><input type="password" name="password" required></div>
      <button class="btn">Login</button>
    </form>
  </div>
</main>
</body></html>
