<?php
require_once __DIR__ . '/../config.php';

if (empty($_SESSION['admin_logged_in'])) {
    header('Location: ' . BASE_URL . '/admin/login.php');
    exit;
}

$pdo = getPDO();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    // Use general uploads directory
    $uploadDir = __DIR__ . '/../uploads/';
    if (!is_dir($uploadDir)) mkdir($uploadDir, 0755, true);

    if (!empty($_FILES['logo']['name'])) {

        $ext = strtolower(pathinfo($_FILES['logo']['name'], PATHINFO_EXTENSION));
        $allowed = ['jpg', 'jpeg', 'png', 'gif'];

        if (!in_array($ext, $allowed)) {
            die("Invalid file type. Allowed: jpg, jpeg, png, gif.");
        }

        $filename = uniqid('event_') . '.' . $ext;
        $filePath = $uploadDir . $filename;

        if (move_uploaded_file($_FILES['logo']['tmp_name'], $filePath)) {

            // Relative path to save in DB
            $logo_path = 'uploads/' . $filename;

            // Update existing event with logo
            if (!empty($_POST['event_id'])) {
                $event_id = intval($_POST['event_id']);
                $stmt = $pdo->prepare("UPDATE events SET logo_path = ? WHERE id = ?");
                $stmt->execute([$logo_path, $event_id]);
            }

            echo "Upload successful! Logo saved at: <a href='" . BASE_URL . "/" . $logo_path . "' target='_blank'>$logo_path</a>";

        } else {
            echo "Error uploading file.";
        }

    } else {
        echo "No file uploaded.";
    }

} else {
    header('Location: ' . BASE_URL . '/admin/dashboard.php');
    exit;
}
