<?php
require_once __DIR__ . '/../config.php';
if (empty($_SESSION['admin_logged_in'])) { header('Location: ' . BASE_URL . '/admin/login.php'); exit; }
$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
if (!$id) die('Missing id');
$pdo = getPDO();
$stmt = $pdo->prepare("SELECT t.*, e.title as event_title, e.event_date FROM tickets t JOIN events e ON t.event_id = e.id WHERE t.id = ?");
$stmt->execute([$id]);
$t = $stmt->fetch();
if (!$t) die('Ticket not found');
?>
<!doctype html>
<html><head><meta charset="utf-8"><title>View Ticket</title>
<link rel="stylesheet" href="<?=BASE_URL?>/assets/css/style.css"></head>
<body>
<main class="container">
  <div class="card">
    <h2>Ticket #<?=intval($t['id'])?></h2>
    <p><strong>Event:</strong> <?=htmlspecialchars($t['event_title'])?></p>
    <p><strong>Buyer:</strong> <?=htmlspecialchars($t['buyer_name'])?> (<?=htmlspecialchars($t['buyer_email'])?>)</p>
    <p><strong>Token:</strong> <code><?=htmlspecialchars($t['token'])?></code></p>
    <p><strong>Status:</strong> <?=htmlspecialchars($t['status'])?></p>
    <p><img src="<?=htmlspecialchars($t['qr_path'])?>" alt="QR" style="max-width:260px"></p>
    <p><a class="btn" href="<?=BASE_URL?>/admin/dashboard.php">Back</a></p>
  </div>
</main>
</body></html>
