<?php
require_once __DIR__ . '/../config.php';
$pdo = getPDO();
header('Content-Type: application/json; charset=utf-8');

$input = json_decode(file_get_contents('php://input'), true);
$token = $input['token'] ?? null;
if (!$token) {
    echo json_encode(['status'=>'error','message'=>'missing token']); exit;
}

if (!preg_match('/^[A-Za-z0-9\-\_]+$/', $token)) {
    echo json_encode(['status'=>'ok','result'=>'invalid']); exit;
}

try {
    $pdo->beginTransaction();
    $stmt = $pdo->prepare("SELECT id, status FROM tickets WHERE token = ? FOR UPDATE");
    $stmt->execute([$token]);
    $t = $stmt->fetch();
    if (!$t) { $pdo->commit(); echo json_encode(['status'=>'ok','result'=>'invalid']); exit; }
    if ($t['status'] === 'used') { $pdo->commit(); echo json_encode(['status'=>'ok','result'=>'used']); exit; }
    $upd = $pdo->prepare("UPDATE tickets SET status = 'used' WHERE id = ?");
    $upd->execute([$t['id']]);
    $pdo->commit();
    echo json_encode(['status'=>'ok','result'=>'valid']); exit;
} catch (Exception $e) {
    $pdo->rollBack();
    http_response_code(500);
    echo json_encode(['status'=>'error','message'=>$e->getMessage()]); exit;
}
