<?php
require_once __DIR__ . '/qr_svg.php';
require_once __DIR__ . '/../config.php';

// Generate secure unique token
function generateToken($prefix = 'TICKET-') {
    return $prefix . bin2hex(random_bytes(16));
}

// Save SVG to file and return paths
function saveQrSvgFile($token) {
    // Ensure QR code directory exists
    if (!is_dir(QRCODE_DIR)) mkdir(QRCODE_DIR, 0775, true);

    // Clean filename
    $safe = preg_replace('/[^A-Za-z0-9_\-]/', '_', $token);
    $fname = $safe . '.svg';

    // File system path
    $file = QRCODE_DIR . $fname;

    // Relative/public path to store in DB (no BASE_URL)
    $public = 'assets/qrcodes/' . $fname;

    // Generate QR SVG content
    $svg = qr_svg($token, 6, 4);
    file_put_contents($file, $svg);

    return [
        'file' => $file,      // for email attachment
        'public' => $public   // store in DB
    ];
}

// Send email with QR attached
function sendTicketEmail($toEmail, $toName, $eventTitle, $token, $svgFilePath) {
    $subject = "Your ticket for $eventTitle";
    $boundary = md5(time());
    $headers = "From: noreply@example.com\r\n";
    $headers .= "MIME-Version: 1.0\r\n";
    $headers .= "Content-Type: multipart/mixed; boundary=\"{$boundary}\"\r\n";

    $message = "--{$boundary}\r\n";
    $message .= "Content-Type: text/html; charset=UTF-8\r\n\r\n";
    $message .= "<p>Hi " . htmlspecialchars($toName) . ",</p>";
    $message .= "<p>Thanks for your purchase. Your token: <code>" . htmlspecialchars($token) . "</code></p>";
    $message .= "<p>Attached is your QR code (SVG). Show the QR at the gate.</p>";
    $message .= "<hr/>";
    $message .= "<p>Ticketing System</p>\r\n";

    $message .= "--{$boundary}\r\n";
    $svgData = file_get_contents($svgFilePath);
    $base64 = chunk_split(base64_encode($svgData));
    $fname = basename($svgFilePath);
    $message .= "Content-Type: image/svg+xml; name=\"{$fname}\"\r\n";
    $message .= "Content-Transfer-Encoding: base64\r\n";
    $message .= "Content-Disposition: attachment; filename=\"{$fname}\"\r\n\r\n";
    $message .= $base64 . "\r\n";
    $message .= "--{$boundary}--";

    return @mail($toEmail, $subject, $message, $headers);
}
