<?php
require_once __DIR__ . '/../config.php';
$pdo = getPDO();

$event_id = filter_input(INPUT_GET, 'event_id', FILTER_VALIDATE_INT);
if (!$event_id) {
    header('Location: ' . BASE_URL . '/public/index.php');
    exit;
}

// Fetch event
$stmt = $pdo->prepare("SELECT * FROM events WHERE id = ?");
$stmt->execute([$event_id]);
$event = $stmt->fetch();
if (!$event) {
    header('Location: ' . BASE_URL . '/public/index.php');
    exit;
}

// Ticket types and prices
$ticket_types = json_decode($event['ticket_prices'], true);
if (!is_array($ticket_types) || empty($ticket_types)) {
    $ticket_types = ['Regular' => (float)$event['price']];
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
<title>Buy Ticket — <?=htmlspecialchars($event['title'])?></title>
<style>
/* Blitz Buy Ticket Page CSS - Same Style & Classiness */

/* =============== GLOBAL RESET =============== */
* {
  margin: 0;
  padding: 0;
  box-sizing: border-box;
  font-family: 'Poppins', sans-serif;
}

body {
  background: #f5f7fb;
  color: #222;
  overflow-x: hidden;
}

a {
  text-decoration: none;
}

/* =============== CONTAINER =============== */
.container {
  width: 90%;
  max-width: 480px;
  margin: 50px auto;
}

/* =============== CARD =============== */
.card {
  background: #fff;
  border-radius: 14px;
  overflow: hidden;
  padding: 30px 25px;
  box-shadow: 0 4px 20px rgba(0,0,0,0.08);
  border-top: 6px solid #00eaff;
  transition: 0.3s ease;
}

.card:hover {
  transform: translateY(-5px);
  box-shadow: 0 10px 25px rgba(0,0,0,0.15);
}

/* =============== HEADING =============== */
.card h2 {
  font-size: 28px;
  font-weight: 700;
  margin-bottom: 20px;
  text-align: center;
  color: #00eaff;
}

/* =============== FORM =============== */
form {
  display: flex;
  flex-direction: column;
}

.form-row {
  margin-bottom: 18px;
}

.form-row label {
  display: block;
  margin-bottom: 6px;
  font-weight: 600;
  color: #222;
}

.form-row input,
.form-row select {
  width: 100%;
  padding: 12px 12px;
  font-size: 15px;
  border-radius: 10px;
  border: 1px solid #00eaff;
  transition: 0.3s ease;
}

.form-row input:focus,
.form-row select:focus {
  outline: none;
  border-color: #00bcd4;
}

/* =============== AMOUNT DISPLAY =============== */
#ticket-price {
  font-weight: 700;
  color: #00eaff;
  font-size: 18px;
  margin-top: 5px;
}

/* =============== BUTTON =============== */
button.btn {
  background: #00eaff;
  color: #000;
  font-weight: 600;
  padding: 14px 0;
  font-size: 16px;
  border: none;
  border-radius: 10px;
  cursor: pointer;
  transition: 0.3s ease;
}

button.btn:hover {
  background: #00bcd4;
  transform: scale(1.03);
}

/* =============== RESPONSIVE =============== */
@media(max-width:480px){
  .card {
    padding: 25px 15px;
  }
  .card h2 {
    font-size: 24px;
  }
  .form-row input,
  .form-row select {
    font-size: 14px;
    padding: 10px;
  }
  button.btn {
    font-size: 14px;
    padding: 12px 0;
  }
}

</style>
</head>
<body>
<main class="container">
  <div class="card">
    <h2>Buy Ticket — <?=htmlspecialchars($event['title'])?></h2>
    <form method="post" action="<?=BASE_URL?>/public/process_payment.php">
      <input type="hidden" name="event_id" value="<?=intval($event['id'])?>">

      <div class="form-row">
        <label>Your Name</label>
        <input name="buyer_name" placeholder="Enter your full name" required>
      </div>

      <div class="form-row">
        <label>Email</label>
        <input name="buyer_email" type="email" placeholder="Enter your email" required>
      </div>

      <div class="form-row">
        <label>Ticket Type</label>
        <select name="ticket_type" required id="ticket_type">
          <?php foreach($ticket_types as $type => $price): ?>
            <option value="<?=htmlspecialchars($type)?>">
              <?=htmlspecialchars($type)?> — GHS <?=number_format($price,2)?>
            </option>
          <?php endforeach; ?>
        </select>
      </div>

      <div class="form-row">
        <p>Amount: GHS <span id="ticket-price"><?=number_format(reset($ticket_types),2)?></span></p>
      </div>

      <button class="btn" type="submit">Pay with Paystack</button>
    </form>
  </div>
</main>

<script>
// Update price dynamically
const ticketSelect = document.getElementById('ticket_type');
const priceSpan = document.getElementById('ticket-price');
const ticketPrices = <?=json_encode($ticket_types)?>;

ticketSelect.addEventListener('change', function(){
    const selected = ticketSelect.value;
    priceSpan.textContent = ticketPrices[selected].toFixed(2);
});
</script>
</body>
</html>
