<?php
require_once __DIR__ . '/../config.php';
$pdo = getPDO();

// Fetch all events
$stmt = $pdo->query("SELECT * FROM events ORDER BY event_date ASC");
$events = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Blitz Events | Discover & Attend</title>

<link rel="stylesheet" href="<?=BASE_URL?>/style.css">
</head>

<body>

<header class="navbar">
    <div class="nav-container">
        <div class="logo">
            <img src="<?=BASE_URL?>/blitz.jpg" alt="Blitz Logo">
            <span>BLITZ EVENTS</span>
        </div>
        <nav>
            <a href="<?=BASE_URL?>/public/index.php">Home</a>
            <a href="<?=BASE_URL?>/public/events.php" class="active">Events</a>
            <a href="<?=BASE_URL?>/public/contact.php">Contact</a>
        </nav>
    </div>
</header>

<!-- ================= HERO SECTION ================= -->
<section class="hero">
    <div class="hero-overlay"></div>
    <div class="hero-content">
        <h1>Discover Amazing Events</h1>
        <p>Experience concerts, parties, conferences and VIP shows—Only on Blitz.</p>
    </div>
</section>


<main class="container">
    <h2 class="section-title">Upcoming Events</h2>

    <?php if (!$events): ?>
        <p class="empty-msg">No upcoming events available.</p>
    <?php else: ?>
    <div class="event-grid">
        <?php foreach ($events as $e): ?>

        <?php 
        // Logo handling
        $logoURL = BASE_URL . '/' . ($e['logo_path'] ?: 'assets/images/default-event.jpg'); 

        // Price handling
        $displayPrice = 'Free';
        if (!empty($e['ticket_prices'])) {
            $ticketPrices = json_decode($e['ticket_prices'], true);
            if (is_array($ticketPrices) && !empty($ticketPrices)) {
                $displayPrice = 'GHS ' . number_format(min($ticketPrices), 2);
            }
        } elseif (!empty($e['price']) && $e['price'] > 0) {
            $displayPrice = 'GHS ' . number_format($e['price'], 2);
        }
        ?>

        <div class="event-card"><img src="<?=BASE_URL?>/blitz.jpg" alt="Blitz Logo" 
     style="height:40px; width:auto; max-width:100%; display:block;">

            <img src="<?=htmlspecialchars($logoURL)?>" alt="<?=htmlspecialchars($e['title'])?>">
            <div class="event-info">
                <h3><?=htmlspecialchars($e['title'])?></h3>
                <p class="desc"><?=nl2br(htmlspecialchars($e['description']))?></p>
                <p><strong>Date:</strong> <?=date("F j, Y • g:i A", strtotime($e['event_date']))?></p>
                <p><strong>Price:</strong> <?=htmlspecialchars($displayPrice)?></p>
                <a class="btn" href="<?=BASE_URL?>/public/buy.php?event_id=<?=intval($e['id'])?>">Buy Ticket</a>
            </div>
        </div>

        <?php endforeach; ?>
    </div>
    <?php endif; ?>
</main>


<footer class="footer">
    <div class="footer-container">
        <div class="footer-about">
            <h3>Blitz Events</h3>
            <p>Your #1 platform for event bookings, tickets & experiences.</p>
        </div>
        <div class="footer-links">
            <h4>Quick Links</h4>
            <a href="<?=BASE_URL?>/public/index.php">Home</a>
            <a href="<?=BASE_URL?>/public/events.php">Events</a>
            <a href="<?=BASE_URL?>/public/contact.php">Contact</a>
        </div>
    </div>
    <div class="footer-bottom">
        &copy; <?=date("Y")?> Blitz Events • All Rights Reserved
    </div>
</footer>

</body>
</html>
