<?php
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../includes/functions.php';
$pdo = getPDO();

$reference = $_GET['reference'] ?? null;
if (!$reference) die('Missing reference');

// Verify transaction
$ch = curl_init('https://api.paystack.co/transaction/verify/' . urlencode($reference));
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Authorization: Bearer ' . PAYSTACK_SECRET,
    'Content-Type: application/json'
]);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$res = curl_exec($ch);
if (curl_errno($ch)) { die('Curl error: ' . curl_error($ch)); }
curl_close($ch);

$json = json_decode($res, true);
if (!$json || !isset($json['status']) || !$json['status']) {
    die('Payment verification failed');
}

$data = $json['data'];
if ($data['status'] !== 'success' && $data['status'] !== 'paid') {
    die('Payment not confirmed: ' . htmlspecialchars($data['status']));
}

// Metadata
$meta = $data['metadata'] ?? [];
$event_id = $meta['event_id'] ?? null;
$buyer_name = $meta['buyer_name'] ?? '';
$buyer_email = $data['customer']['email'] ?? '';
$ticket_type = $meta['ticket_type'] ?? 'Regular';

if (!$event_id || !$buyer_email) die('Missing metadata');

// Ensure unique token
do {
    $token = generateToken();
    $stmt = $pdo->prepare("SELECT id FROM tickets WHERE token = ?");
    $stmt->execute([$token]);
    $exists = $stmt->fetch();
} while ($exists);

// Generate QR code
$qr = saveQrSvgFile($token);

// Insert ticket
$ins = $pdo->prepare("
    INSERT INTO tickets 
    (event_id, buyer_name, buyer_email, ticket_type, token, qr_path, status)
    VALUES (?, ?, ?, ?, ?, ?, 'valid')
");
$ins->execute([$event_id, $buyer_name, $buyer_email, $ticket_type, $token, $qr['public']]);
$ticket_id = $pdo->lastInsertId();

// Send email
sendTicketEmail($buyer_email, $buyer_name, 'Ticketed Event', $token, $qr['file']);

// Redirect to success page
header('Location: ' . BASE_URL . '/public/success.php?ticket_id=' . intval($ticket_id));
exit;
