<?php
require_once __DIR__ . '/../config.php';
$pdo = getPDO();

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: ' . BASE_URL . '/public/index.php');
    exit;
}

$event_id = filter_input(INPUT_POST, 'event_id', FILTER_VALIDATE_INT);
$buyer_name = trim(filter_input(INPUT_POST, 'buyer_name', FILTER_SANITIZE_FULL_SPECIAL_CHARS));
$buyer_email = trim(filter_input(INPUT_POST, 'buyer_email', FILTER_VALIDATE_EMAIL));
$ticket_type = $_POST['ticket_type'] ?? '';

if (!$event_id || !$buyer_name || !$buyer_email || !$ticket_type) {
    die('Invalid input.');
}

// Fetch event
$stmt = $pdo->prepare("SELECT * FROM events WHERE id = ?");
$stmt->execute([$event_id]);
$event = $stmt->fetch();
if (!$event) die('Event not found.');

// Get ticket prices
$ticket_prices = json_decode($event['ticket_prices'], true);
if (!is_array($ticket_prices) || !isset($ticket_prices[$ticket_type])) {
    die('Invalid ticket type selected.');
}

// Amount in Kobo
$amount_kobo = (int)round($ticket_prices[$ticket_type]*100);

// Callback URL
$callback_url = (isset($_SERVER['HTTPS']) ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST'] . BASE_URL . '/public/payment_callback.php';

// Metadata
$meta = [
    'event_id' => $event_id,
    'buyer_name' => $buyer_name,
    'ticket_type' => $ticket_type
];

// Initialize Paystack transaction
$payload = json_encode([
    'email' => $buyer_email,
    'amount' => $amount_kobo,
    'callback_url' => $callback_url,
    'metadata' => $meta
]);

$ch = curl_init('https://api.paystack.co/transaction/initialize');
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Authorization: Bearer ' . PAYSTACK_SECRET,
    'Content-Type: application/json'
]);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
$response = curl_exec($ch);
if (curl_errno($ch)) die('Curl error: ' . curl_error($ch));
curl_close($ch);

$res = json_decode($response,true);
if (!$res || !$res['status']) {
    $msg = $res['message'] ?? 'Payment initialization failed';
    die('Paystack Error: ' . htmlspecialchars($msg));
}

// Redirect user to Paystack checkout
header('Location: ' . $res['data']['authorization_url']);
exit;
