<?php 
require_once __DIR__ . '/../config.php';
$pdo = getPDO();

$ticket_id = filter_input(INPUT_GET, 'ticket_id', FILTER_VALIDATE_INT);
if (!$ticket_id) die('No ticket ID');

$stmt = $pdo->prepare("
    SELECT t.*, e.title AS event_title, e.logo_path
    FROM tickets t 
    JOIN events e ON t.event_id = e.id 
    WHERE t.id = ?
");
$stmt->execute([$ticket_id]);
$ticket = $stmt->fetch();
if (!$ticket) die('Ticket not found');
?>
<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8">
<title>Ticket Success</title>
<style>/* Blitz Ticket Page - Modern, Classy Style */

/* =============== GLOBAL STYLES =============== */
body {
    font-family: 'Poppins', sans-serif;
    background: linear-gradient(to right, #4facfe, #00f2fe);
    color: #222;
    margin: 0;
    padding: 0;
    min-height: 100vh;
}

/* =============== TICKET CONTAINER =============== */
.ticket-container {
    max-width: 600px;
    margin: 60px auto;
    background: #fff;
    border-radius: 14px;
    padding: 30px 25px;
    box-shadow: 0 10px 25px rgba(0, 0, 0, 0.18);
    text-align: center;
    transition: 0.3s ease;
}

.ticket-container:hover {
    transform: translateY(-5px);
    box-shadow: 0 15px 30px rgba(0,0,0,0.2);
}

/* =============== LOGO =============== */
.ticket-container img.logo {
    max-height: 100px;
    margin-bottom: 25px;
}

/* =============== HEADING =============== */
.ticket-container h2 {
    color: #00eaff;
    font-size: 28px;
    font-weight: 700;
    margin-bottom: 25px;
}

/* =============== TICKET DETAILS =============== */
.ticket-details {
    text-align: left;
    margin-bottom: 25px;
}

.ticket-details p {
    margin: 10px 0;
    font-size: 16px;
    color: #555;
}

.ticket-details code {
    background: #f1f1f1;
    padding: 3px 8px;
    border-radius: 5px;
    font-size: 14px;
    color: #333;
}

/* =============== QR CODE =============== */
.qr-code img {
    margin-top: 25px;
    width: 200px;
    height: 200px;
    border-radius: 12px;
    box-shadow: 0 6px 20px rgba(0,0,0,0.15);
    transition: 0.3s ease;
}

.qr-code img:hover {
    transform: scale(1.05);
}

/* =============== BUTTON =============== */
.btn {
    display: inline-block;
    margin-top: 20px;
    padding: 12px 25px;
    background: #00eaff;
    color: #000;
    font-weight: 600;
    border-radius: 10px;
    font-size: 16px;
    cursor: pointer;
    transition: 0.3s ease;
}

.btn:hover {
    background: #00bcd4;
    transform: scale(1.03);
}

/* =============== RESPONSIVE =============== */
@media(max-width: 650px) {
    .ticket-container {
        margin: 20px;
        padding: 20px;
    }
    .ticket-container h2 {
        font-size: 24px;
    }
    .qr-code img {
        width: 150px;
        height: 150px;
    }
    .ticket-details p {
        font-size: 15px;
    }
    .btn {
        padding: 10px 20px;
        font-size: 15px;
    }
}

</style>
</head>
<body>
<div class="ticket-container">
    <?php if (!empty($ticket['logo_path']) && file_exists(__DIR__ . '/../' . $ticket['logo_path'])): ?>
        <img src="<?=BASE_URL?>/<?=htmlspecialchars($ticket['logo_path'])?>" class="logo" alt="Event Logo">
    <?php endif; ?>
    <h2>Ticket Purchased Successfully!</h2>
    <div class="ticket-details">
        <p><strong>Event:</strong> <?=htmlspecialchars($ticket['event_title'])?></p>
        <p><strong>Name:</strong> <?=htmlspecialchars($ticket['buyer_name'])?></p>
        <p><strong>Email:</strong> <?=htmlspecialchars($ticket['buyer_email'])?></p>
        <p><strong>Type:</strong> <?=htmlspecialchars($ticket['ticket_type'])?></p>
        <p><strong>Token:</strong> <code><?=htmlspecialchars($ticket['token'])?></code></p>
    </div>
    <div class="qr-code">
    <?php if (!empty($ticket['qr_path']) && file_exists(__DIR__ . '/../' . $ticket['qr_path'])): ?>
        <img src="<?=BASE_URL?>/<?=htmlspecialchars($ticket['qr_path'])?>" alt="QR Code">
    <?php else: ?>
        <p>QR code not found. Please contact support.</p>
    <?php endif; ?>
    </div>
</div>
</body>
</html>
