<?php
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../vendor/tcpdf/tcpdf.php'; // Make sure TCPDF is installed via Composer

$pdo = getPDO();

$ticket_id = filter_input(INPUT_GET, 'ticket_id', FILTER_VALIDATE_INT);
if (!$ticket_id) die('No ticket ID');

$stmt = $pdo->prepare("
    SELECT t.*, e.title AS event_title, e.logo_path
    FROM tickets t
    JOIN events e ON t.event_id = e.id
    WHERE t.id = ?
");
$stmt->execute([$ticket_id]);
$ticket = $stmt->fetch();
if (!$ticket) die('Ticket not found');

// Generate QR code as PNG
$qrData = $ticket['token'];
$qrFile = __DIR__ . '/../assets/qrcodes/' . $ticket['token'] . '.png';

if (!file_exists($qrFile)) {
    require_once __DIR__ . '/../includes/phpqrcode/qrlib.php'; // Use phpqrcode library
    QRcode::png($qrData, $qrFile, QR_ECLEVEL_L, 4);
}

// Create TCPDF object
$pdf = new TCPDF('P', 'mm', 'A6', true, 'UTF-8', false);
$pdf->SetCreator('Ticketing System');
$pdf->SetTitle('Ticket - ' . $ticket['event_title']);
$pdf->SetMargins(10, 10, 10);
$pdf->SetAutoPageBreak(true, 10);
$pdf->AddPage();

// Background color
$pdf->SetFillColor(240, 248, 255); // light professional blue
$pdf->Rect(0, 0, 105, 148, 'F');

// Event logo
if (!empty($ticket['logo_path']) && file_exists(__DIR__ . '/../' . $ticket['logo_path'])) {
    $pdf->Image(__DIR__ . '/../' . $ticket['logo_path'], 35, 10, 35, 35, '', '', '', true);
}

// Ticket title
$pdf->SetFont('helvetica', 'B', 16);
$pdf->SetY(50);
$pdf->Cell(0, 10, strtoupper($ticket['event_title']), 0, 1, 'C');

// Ticket info
$pdf->SetFont('helvetica', '', 12);
$pdf->Ln(2);
$pdf->Cell(0, 6, 'Name: ' . $ticket['buyer_name'], 0, 1);
$pdf->Cell(0, 6, 'Email: ' . $ticket['buyer_email'], 0, 1);
$pdf->Cell(0, 6, 'Type: ' . $ticket['ticket_type'], 0, 1);
$pdf->Cell(0, 6, 'Token: ' . $ticket['token'], 0, 1);

// QR code
$pdf->Image($qrFile, 35, 90, 35, 35, 'PNG');

// Footer
$pdf->SetY(135);
$pdf->SetFont('helvetica', 'I', 8);
$pdf->Cell(0, 6, 'Show this QR code at the event entrance.', 0, 1, 'C');

// Output PDF
$pdf->Output('Ticket_' . $ticket['token'] . '.pdf', 'I'); // I = inline view in browser
