<?php
require 'config.php';
if (session_status() === PHP_SESSION_NONE) session_start();

if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

$msg = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = $_POST['name'];
    $category = $_POST['category']; // <-- new
    $desc = $_POST['description'];
    $price = $_POST['price'];
    $user_id = $_SESSION['user_id'];
    $image_name = '';

    if (isset($_FILES['image']) && $_FILES['image']['error'] == 0) {
        $ext = pathinfo($_FILES['image']['name'], PATHINFO_EXTENSION);
        $image_name = uniqid() . '.' . $ext;
        move_uploaded_file($_FILES['image']['tmp_name'], 'uploads/' . $image_name);
    }

    $stmt = $mysqli->prepare('INSERT INTO products (user_id, name, category, description, price, image) VALUES (?,?,?,?,?,?)');
    $stmt->bind_param('isssds', $user_id, $name, $category, $desc, $price, $image_name);

    if ($stmt->execute()) {
        header('Location: dashboard.php');
        exit;
    } else {
        $msg = '❌ Error adding product. Try again.';
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Add Product | ShopGRL</title>
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">
<style>
:root {
  --gold: #d4af37;
  --dark: #0f0f0f;
  --light: #f8f8f8;
  --white: #fff;
  --shadow: 0 6px 18px rgba(0,0,0,0.1);
}

body {
  font-family: 'Poppins', sans-serif;
  background: var(--light);
  display: flex;
  justify-content: center;
  align-items: center;
  height: 100vh;
  margin: 0;
}

.container {
  background: var(--white);
  box-shadow: var(--shadow);
  padding: 2rem;
  border-radius: 12px;
  width: 95%;
  max-width: 500px;
  text-align: center;
}

h2 {
  color: var(--gold);
  margin-bottom: 1rem;
}

form {
  display: flex;
  flex-direction: column;
  gap: 15px;
}

input, textarea, select {
  padding: 12px;
  border: 1px solid #ddd;
  border-radius: 8px;
  font-size: 1rem;
  transition: 0.3s;
}

input:focus, textarea:focus, select:focus {
  outline: none;
  border-color: var(--gold);
  box-shadow: 0 0 5px rgba(212,175,55,0.4);
}

button {
  background: var(--gold);
  color: var(--white);
  border: none;
  padding: 12px;
  border-radius: 8px;
  font-weight: 600;
  cursor: pointer;
  transition: 0.3s;
}

button:hover {
  background: #b9962d;
}

.preview {
  margin-top: 10px;
  display: none;
}

.preview img {
  width: 100%;
  max-height: 220px;
  border-radius: 10px;
  object-fit: cover;
  box-shadow: var(--shadow);
  margin-top: 10px;
}

.message {
  color: red;
  font-weight: 600;
  margin-bottom: 10px;
}

.success {
  color: green;
}

.back {
  display: inline-block;
  margin-top: 15px;
  text-decoration: none;
  color: var(--dark);
  font-weight: 500;
}

.back:hover {
  color: var(--gold);
}

/* Responsive */
@media (max-width: 600px) {
  .container { padding: 1.5rem; }
}
</style>
</head>
<body>

<div class="container">
  <h2><i class="bi bi-box-seam"></i> Add New Product</h2>
  <?php if ($msg): ?>
    <p class="message"><?= htmlspecialchars($msg) ?></p>
  <?php endif; ?>

  <form method="POST" enctype="multipart/form-data" onsubmit="return validateForm()">
    <input type="text" name="name" id="name" placeholder="Product Name" required>

    <!-- Category Select -->
    <select name="category" id="category" required>
      <option value="" disabled selected>Select Category</option>
      <option value="Fashion">Fashion</option>
      <option value="Food">Food</option>
      <option value="Electronics">Electronics</option>
      <option value="Beauty">Beauty</option>
      <option value="Home & Living">Home & Living</option>
      <option value="Sports">Sports</option>
      <option value="Other">Other</option>
    </select>

    <textarea name="description" id="desc" placeholder="Product Description" required></textarea>
    <input type="number" step="0.01" name="price" id="price" placeholder="Price (GH$)" required>
    
    <input type="file" name="image" id="image" accept="image/*" required onchange="previewImage(event)">
    <div class="preview" id="previewBox">
      <img id="previewImg" src="#" alt="Image Preview">
    </div>

    <button type="submit"><i class="bi bi-check-circle"></i> Add Product</button>
  </form>
  <a href="dashboard.php" class="back"><i class="bi bi-arrow-left"></i> Back to Dashboard</a>
</div>

<script>
function previewImage(event) {
  const file = event.target.files[0];
  const previewBox = document.getElementById('previewBox');
  const previewImg = document.getElementById('previewImg');

  if (file) {
    previewImg.src = URL.createObjectURL(file);
    previewBox.style.display = 'block';
  } else {
    previewBox.style.display = 'none';
  }
}

function validateForm() {
  const name = document.getElementById('name').value.trim();
  const category = document.getElementById('category').value;
  const desc = document.getElementById('desc').value.trim();
  const price = document.getElementById('price').value.trim();
  const image = document.getElementById('image').files.length;

  if (name.length < 3) {
    alert('Product name must be at least 3 characters.');
    return false;
  }
  if (!category) {
    alert('Please select a product category.');
    return false;
  }
  if (desc.length < 10) {
    alert('Description must be at least 10 characters.');
    return false;
  }
  if (price <= 0) {
    alert('Please enter a valid price.');
    return false;
  }
  if (!image) {
    alert('Please upload a product image.');
    return false;
  }
  return true;
}
</script>

</body>
</html>
