<?php
require 'config.php';

// Make sure user is logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

// Fetch all verification requests (you could filter by user's own sellers if needed)
$requests = $mysqli->query("SELECT * FROM verification_requests ORDER BY created_at DESC");
?>
<!DOCTYPE html>
<html>
<head>
  <title>Verification Panel - ShopGRL</title>
  <link rel="stylesheet" href="style.css">
  <style>
    body {
      font-family: Arial, sans-serif;
      background: #fafafa;
      padding: 20px;
    }
    table {
      border-collapse: collapse;
      width: 100%;
      background: white;
      box-shadow: 0 2px 6px rgba(0,0,0,0.1);
    }
    th, td {
      padding: 10px;
      border: 1px solid #ddd;
      text-align: left;
    }
    th {
      background: #111;
      color: gold;
    }
    h2 {
      color: #111;
      margin-bottom: 15px;
    }
    button {
      padding: 5px 10px;
      border: none;
      cursor: pointer;
      border-radius: 4px;
    }
    button[name="action"][value="approve"] {
      background: #28a745;
      color: white;
    }
    button[name="action"][value="reject"] {
      background: #dc3545;
      color: white;
    }
  </style>
</head>
<body>
  <h2>Seller Verification Requests</h2>

  <?php if ($requests->num_rows > 0): ?>
  <table>
    <tr>
      <th>ID</th>
      <th>Seller</th>
      <th>Email</th>
      <th>Business</th>
      <th>Link</th>
      <th>Status</th>
      <th>Action</th>
    </tr>
    <?php while ($row = $requests->fetch_assoc()): ?>
    <tr>
      <td><?= $row['id'] ?></td>
      <td><?= htmlspecialchars($row['full_name']) ?></td>
      <td><?= htmlspecialchars($row['email']) ?></td>
      <td><?= htmlspecialchars($row['business_name']) ?></td>
      <td><a href="<?= htmlspecialchars($row['business_link']) ?>" target="_blank">View Shop</a></td>
      <td><?= ucfirst(htmlspecialchars($row['status'])) ?></td>
      <td>
        <form method="POST" action="update_verification.php" style="display:inline;">
          <input type="hidden" name="id" value="<?= $row['id'] ?>">
          <button name="action" value="approve">✅ Approve</button>
          <button name="action" value="reject">❌ Reject</button>
        </form>
      </td>
    </tr>
    <?php endwhile; ?>
  </table>
  <?php else: ?>
    <p>No verification requests yet.</p>
  <?php endif; ?>

</body>
</html>
