<?php
require 'config.php';
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

$id = $_SESSION['user_id'];
$user = $mysqli->query("SELECT * FROM users WHERE id = $id")->fetch_assoc();
$base_url = (strpos($_SERVER['HTTP_HOST'], 'localhost') !== false)
    ? 'http://localhost/GRL/'
    : 'https://' . $_SERVER['HTTP_HOST'] . '/';

// Generate a slug from the brand name
$slug = strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', $user['brand_name'])));

// Create shop link
$shop_link = $base_url . 'shop/' . $slug;

// Update database if shop_link is missing or outdated
if (empty($user['shop_link']) || $user['shop_link'] !== $shop_link) {
    $stmt = $mysqli->prepare("UPDATE users SET shop_link = ? WHERE id = ?");
    $stmt->bind_param("si", $shop_link, $id);
    $stmt->execute();
    $user['shop_link'] = $shop_link;
}

$products = $mysqli->query("SELECT * FROM products WHERE user_id = $id");
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title><?= htmlspecialchars($user['brand_name']) ?> Dashboard | ShopGRL</title>

<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">

<style>
  /* ============================
   SHOPGRL DASHBOARD THEME
   Light Mode (Black & Gold)
============================ */

:root {
  --gold: #d4af37;
  --dark: #121212;
  --light: #fafafa;
  --white: #fff;
  --gray: #777;
  --shadow: 0 6px 18px rgba(0,0,0,0.08);
  --radius: 12px;
  --transition: all 0.3s ease;
}

/* ============================
   GLOBAL RESET
============================ */
* {
  margin: 0;
  padding: 0;
  box-sizing: border-box;
}

body {
  font-family: "Poppins", sans-serif;
  background: var(--light);
  color: var(--dark);
  display: flex;
  min-height: 100vh;
  transition: var(--transition);
}

a {
  color: var(--gold);
  text-decoration: none;
}

a:hover {
  text-decoration: underline;
}

/* ============================
   SIDEBAR
============================ */
.sidebar {
  width: 250px;
  background: var(--white);
  box-shadow: var(--shadow);
  padding: 2rem 1.2rem;
  display: flex;
  flex-direction: column;
  gap: 1rem;
  position: fixed;
  top: 0;
  left: 0;
  height: 100%;
  z-index: 10;
}

.sidebar h2 {
  color: var(--gold);
  font-size: 1.5rem;
  font-weight: 700;
  margin-bottom: 1rem;
}

.sidebar a {
  display: block;
  color: var(--dark);
  font-weight: 500;
  padding: 0.7rem 1rem;
  border-radius: var(--radius);
  transition: var(--transition);
}

.sidebar a:hover,
.sidebar a.active {
  background: var(--gold);
  color: var(--white);
}

.toggle-btn {
  display: none;
  position: fixed;
  top: 15px;
  left: 15px;
  background: var(--gold);
  border: none;
  color: var(--white);
  padding: 8px 10px;
  border-radius: 8px;
  cursor: pointer;
  z-index: 20;
}

/* ============================
   MAIN CONTENT
============================ */
main {
  margin-left: 270px;
  padding: 2rem;
  flex: 1;
  transition: var(--transition);
}

/* ============================
   HEADER
============================ */
header {
  background: var(--white);
  box-shadow: var(--shadow);
  border-radius: var(--radius);
  padding: 1rem 2rem;
  display: flex;
  justify-content: space-between;
  align-items: center;
  flex-wrap: wrap;
}

header h1 {
  color: var(--gold);
  display: flex;
  align-items: center;
  gap: 10px;
  font-size: 1.6rem;
}

.badge {
  display: inline-flex;
  align-items: center;
  background: #f0ffe9;
  color: #267b24;
  font-size: 0.85rem;
  font-weight: 600;
  padding: 4px 12px;
  border-radius: 20px;
  border: 1px solid #267b24;
}

.badge img {
  width: 18px;
  height: 18px;
  margin-right: 6px;
}

/* ============================
   DARK MODE TOGGLE
============================ */
.dark-toggle {
  background: transparent;
  border: 2px solid var(--gold);
  color: var(--gold);
  border-radius: 10px;
  padding: 8px 14px;
  cursor: pointer;
  font-weight: 600;
  transition: var(--transition);
}

.dark-toggle:hover {
  background: var(--gold);
  color: var(--white);
}

/* ============================
   SEARCH BAR
============================ */
.search-bar {
  margin: 1.5rem 0;
  display: flex;
  gap: 10px;
  flex-wrap: wrap;
}

.search-bar input,
.search-bar select {
  padding: 10px 14px;
  border-radius: var(--radius);
  border: 1px solid #ccc;
  flex: 1;
  font-size: 1rem;
}

.search-bar button {
  background: var(--gold);
  color: var(--white);
  border: none;
  padding: 10px 18px;
  border-radius: var(--radius);
  font-weight: 600;
  cursor: pointer;
  transition: var(--transition);
}

.search-bar button:hover {
  background: #b9962d;
}

/* ============================
   CARD CONTAINERS
============================ */
.card {
  background: var(--white);
  border-radius: var(--radius);
  box-shadow: var(--shadow);
  padding: 1.5rem;
  margin-bottom: 1.5rem;
  transition: var(--transition);
}

.card:hover {
  transform: translateY(-3px);
}

.card h3 {
  color: var(--gold);
  margin-bottom: 1rem;
}

/* ============================
   SHOP LINK BUTTONS
============================ */
#copyLinkBtn,
#shareLinkBtn {
  border: none;
  border-radius: 6px;
  padding: 6px 10px;
  font-weight: 600;
  cursor: pointer;
  margin-left: 6px;
  transition: var(--transition);
}

#copyLinkBtn {
  background: var(--gold);
  color: var(--dark);
}

#shareLinkBtn {
  background: var(--dark);
  color: var(--gold);
}

#copyLinkBtn:hover {
  background: #c19c2d;
}

#shareLinkBtn:hover {
  background: #000;
}

/* ============================
   PRODUCT GRID
============================ */
.grid {
  display: grid;
  grid-template-columns: repeat(auto-fill, minmax(230px, 1fr));
  gap: 1.2rem;
}

.product {
  background: var(--white);
  border-radius: var(--radius);
  box-shadow: var(--shadow);
  overflow: hidden;
  transition: var(--transition);
}

.product:hover {
  transform: translateY(-4px);
  box-shadow: 0 8px 22px rgba(0,0,0,0.15);
}

.product img {
  width: 100%;
  height: 170px;
  object-fit: cover;
}

.product-content {
  padding: 1rem;
}

.product h4 {
  margin: 0;
  font-size: 1rem;
  font-weight: 600;
  color: var(--dark);
}

.product p {
  color: var(--gray);
  font-size: 0.9rem;
  margin-top: 6px;
}

.actions a {
  font-weight: 600;
  margin-right: 10px;
  transition: var(--transition);
}

.actions a:hover {
  text-decoration: underline;
}

/* ============================
   RESPONSIVE
============================ */
@media (max-width: 768px) {
  .sidebar {
    transform: translateX(-100%);
    transition: var(--transition);
  }

  .sidebar.active {
    transform: translateX(0);
  }

  .toggle-btn {
    display: block;
  }

  main {
    margin-left: 0;
    padding: 1.5rem;
  }
}

@media (max-width: 480px) {
  .product img {
    height: 130px;
  }
}

</style>
</head>
<body>

<button class="toggle-btn">☰</button>

<div class="sidebar">
  <h2>ShopGRL</h2>
  <a href="dashboard.php">🏠 Dashboard</a>
     <a href="verify_request.php" class="verify-btn">✅ Request Verification</a>
  <a href="add_product.php">➕ Add Product</a>
   <a href="my_purchases.php">🧾 Sales</a>
  <a href="edit_profile.php">🧑‍💼 Edit Profile</a>
    

  <a href="logout.php">🚪 Logout</a>
</div>

<main>
  <header>
    <h1>
      <?= htmlspecialchars($user['brand_name']) ?>
      <?php if (!empty($user['is_verified']) && $user['is_verified'] == 1): ?>
        <span class="badge">
          <img src="uploads/68e2fea3c8574.png" alt="Verified"> Verified
        </span>
      <?php endif; ?>
    </h1>
    <button class="dark-toggle">🌙 Toggle Dark Mode</button>
  </header>

  <div class="search-bar">
    <input type="text" id="searchInput" placeholder="Search your products...">
    <select id="filterSelect">
      <option value="">All Categories</option>
      <option value="Fashion">Fashion</option>
      <option value="Electronics">Electronics</option>
      <option value="Beauty">Beauty</option>
    </select>
    <button onclick="filterProducts()">Search</button>
  </div>

  <div class="card">
    <h3>Your Brand Info</h3>
    <p><strong>Category:</strong> <?= htmlspecialchars($user['category']) ?></p>
    <p><strong>Location:</strong> <?= htmlspecialchars($user['location']) ?></p>
    <p><strong>Email:</strong> <?= htmlspecialchars($user['email']) ?></p>
    <p><strong>Phone:</strong> <?= htmlspecialchars($user['phone']) ?></p>
    <?php if (!empty($user['shop_link'])): ?>
     <p><strong>Shop Link:</strong>
  <a id="shopLink" href="<?= htmlspecialchars($user['shop_link']) ?>" target="_blank">
    <?= htmlspecialchars($user['shop_link']) ?>
  </a>
  <button type="button" id="copyLinkBtn" 
          style="background:#d4af37;border:none;padding:5px 10px;border-radius:6px;
                 color:#000;font-weight:600;margin-left:6px;cursor:pointer;">
    📋 Copy
  </button>
  <button type="button" id="shareLinkBtn" 
          style="background:#000;border:none;padding:5px 10px;border-radius:6px;
                 color:#d4af37;font-weight:600;margin-left:4px;cursor:pointer;">
    🔗 Share
  </button>
</p>
    <?php endif; ?>
  </div>

 <div class="card">
    <h3>Your Products</h3>
    <?php if ($products->num_rows > 0): ?>
  <div class="grid" id="productGrid">
    <?php while ($p = $products->fetch_assoc()): ?>
      <div class="product"
           data-name="<?= htmlspecialchars(strtolower($p['name'])) ?>"
           data-description="<?= htmlspecialchars(strtolower($p['description'])) ?>"
           data-category="<?= htmlspecialchars(strtolower($p['category'])) ?>">
        <?php if (!empty($p['image'])): ?>
          <img src="uploads/<?= htmlspecialchars($p['image']) ?>" alt="<?= htmlspecialchars($p['name']) ?>">
        <?php endif; ?>

        <div class="product-content">
          <h4><?= htmlspecialchars($p['name']) ?></h4>
          <p><strong>Category:</strong> <?= htmlspecialchars($p['category']) ?></p>
          <p><?= htmlspecialchars($p['description']) ?></p>
          <p><strong>Price:</strong> $<?= htmlspecialchars($p['price']) ?></p>
          <div class="actions">
            <a href="edit_product.php?id=<?= $p['id'] ?>">✏️ Edit</a>
            <a href="delete_product.php?id=<?= $p['id'] ?>" class="delete-btn">🗑️ Delete</a>
          </div>
        </div>
      </div>
    <?php endwhile; ?>
  </div>
<?php else: ?>
  <p>You haven't added any products yet.</p>
<?php endif; ?>
</div>

</main>

<script>
// Sidebar toggle for mobile
const sidebar = document.querySelector('.sidebar');
document.querySelector('.toggle-btn').onclick = () => {
  sidebar.classList.toggle('active');
};

// Dark mode toggle
const toggleDark = document.querySelector('.dark-toggle');
toggleDark.onclick = () => {
  document.body.classList.toggle('dark');
  toggleDark.textContent = document.body.classList.contains('dark') ? '☀️ Light Mode' : '🌙 Toggle Dark Mode';
};

// Product search + filter
function filterProducts() {
  const search = document.getElementById('searchInput').value.toLowerCase();
  const category = document.getElementById('filterSelect').value.toLowerCase();
  const products = document.querySelectorAll('#productGrid .product');

  products.forEach(p => {
    const name = p.dataset.name;
    const cat = p.dataset.category;
    if ((name.includes(search) || search === '') && (category === '' || cat === category)) {
      p.style.display = 'block';
    } else {
      p.style.display = 'none';
    }
  });
}

// Confirm delete
document.querySelectorAll('.delete-btn').forEach(btn => {
  btn.addEventListener('click', e => {
    if (!confirm('Are you sure you want to delete this product?')) e.preventDefault();
  });
});
</script>

<script>
document.getElementById('copyLinkBtn').addEventListener('click', function() {
  const link = document.getElementById('shopLink').href;
  navigator.clipboard.writeText(link)
    .then(() => alert('✅ Shop link copied to clipboard!'))
    .catch(() => alert('❌ Unable to copy link.'));
});

document.getElementById('shareLinkBtn').addEventListener('click', function() {
  const link = document.getElementById('shopLink').href;
  if (navigator.share) {
    navigator.share({
      title: 'ShopGRL Seller',
      text: 'Check out this amazing shop on ShopGRL!',
      url: link
    }).catch(err => console.log('Share cancelled:', err));
  } else {
    navigator.clipboard.writeText(link);
    alert('📋 Link copied! You can paste it to share.');
  }
});
</script>
</body>
</html>
