<?php
require 'config.php';
if (!isset($_SESSION['user_id'])) { 
    header('Location: login.php'); 
    exit; 
}

$id = $_GET['id'] ?? 0;
$user_id = $_SESSION['user_id'];
$msg = '';

$product = $mysqli->query("SELECT * FROM products WHERE id=$id AND user_id=$user_id")->fetch_assoc();
if (!$product) { die("Product not found or unauthorized."); }

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = $_POST['name'];
    $desc = $_POST['description'];
    $price = $_POST['price'];

    $image_name = $product['image'];
    if (!empty($_FILES['image']['name'])) {
        $ext = pathinfo($_FILES['image']['name'], PATHINFO_EXTENSION);
        $image_name = uniqid().'.'.$ext;
        move_uploaded_file($_FILES['image']['tmp_name'], 'uploads/'.$image_name);
    }

    $stmt = $mysqli->prepare("UPDATE products SET name=?, description=?, price=?, image=? WHERE id=? AND user_id=?");
    $stmt->bind_param("ssdssi", $name, $desc, $price, $image_name, $id, $user_id);
    if ($stmt->execute()) {
        header("Location: dashboard.php");
        exit;
    } else {
        $msg = 'Error updating product.';
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Edit Product | ShopGRL</title>
<style>
:root {
  --gold: #d4af37;
  --dark: #0b0b0b;
  --light: #f8f8f8;
  --white: #fff;
  --shadow: 0 6px 18px rgba(0, 0, 0, 0.1);
  --radius: 12px;
}

body {
  background: var(--light);
  font-family: 'Poppins', sans-serif;
  margin: 0;
  padding: 0;
}

.container {
  max-width: 500px;
  background: var(--white);
  margin: 60px auto;
  padding: 25px;
  border-radius: var(--radius);
  box-shadow: var(--shadow);
  text-align: center;
}

h2 {
  color: var(--gold);
  margin-bottom: 20px;
  font-weight: 700;
  letter-spacing: 0.5px;
}

form {
  display: flex;
  flex-direction: column;
  gap: 15px;
  text-align: left;
}

input[type="text"],
input[type="number"],
textarea,
input[type="file"] {
  padding: 12px;
  border: 1px solid #ddd;
  border-radius: var(--radius);
  font-size: 1rem;
  font-family: inherit;
  width: 100%;
  box-sizing: border-box;
  transition: 0.3s;
}

input:focus,
textarea:focus {
  outline: none;
  border-color: var(--gold);
  box-shadow: 0 0 5px rgba(212,175,55,0.4);
}

button {
  background: var(--gold);
  color: var(--dark);
  border: none;
  padding: 12px;
  border-radius: var(--radius);
  cursor: pointer;
  font-size: 1rem;
  font-weight: 600;
  transition: 0.3s;
}

button:hover {
  background: #c19e34;
}

.preview {
  text-align: center;
}

.preview img {
  width: 140px;
  height: auto;
  border-radius: 10px;
  margin-top: 10px;
  box-shadow: var(--shadow);
}

.message {
  color: red;
  font-size: 0.95rem;
  text-align: center;
}

.back-link {
  display: inline-block;
  margin-top: 15px;
  color: var(--gold);
  font-weight: 600;
  text-decoration: none;
}

.back-link:hover {
  text-decoration: underline;
}

@media (max-width: 600px) {
  .container {
    margin: 30px 15px;
    padding: 20px;
  }
}
</style>

<script>
document.addEventListener("DOMContentLoaded", () => {
  const imageInput = document.querySelector('input[name="image"]');
  const previewContainer = document.querySelector('.preview img');

  imageInput.addEventListener('change', e => {
    const file = e.target.files[0];
    if (file) {
      previewContainer.src = URL.createObjectURL(file);
    }
  });
});
</script>
</head>

<body>
<div class="container">
  <h2>Edit Product</h2>
  <?php if ($msg): ?><p class="message"><?= htmlspecialchars($msg) ?></p><?php endif; ?>

  <form method="post" enctype="multipart/form-data">
    <label>Product Name</label>
    <input type="text" name="name" value="<?= htmlspecialchars($product['name']) ?>" required>

    <label>Description</label>
    <textarea name="description" rows="4" required><?= htmlspecialchars($product['description']) ?></textarea>

    <label>Price ($)</label>
    <input type="number" step="0.01" name="price" value="<?= htmlspecialchars($product['price']) ?>" required>

    <div class="preview">
      <img src="uploads/<?= htmlspecialchars($product['image']) ?>" alt="Current Image">
    </div>

    <label>Change Image</label>
    <input type="file" name="image" accept="image/*">

    <button type="submit">Update Product</button>
  </form>

  <a class="back-link" href="dashboard.php">← Back to Dashboard</a>
</div>
</body>
</html>
