<?php
require 'config.php';
if (session_status() === PHP_SESSION_NONE) session_start();

if (!isset($_SESSION['user_id'])) { 
    header('Location: login.php'); 
    exit; 
}

$id = $_SESSION['user_id'];
$msg = '';
$user = $mysqli->query("SELECT * FROM users WHERE id=$id")->fetch_assoc();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $brand = trim($_POST['brand_name']);
    $cat = trim($_POST['category']);
    $loc = trim($_POST['location']);
    $phone = trim($_POST['phone']);
    $email = trim($_POST['email']);
    $new_pass = $_POST['new_password'];

    // If password field is not empty, update it securely
    if (!empty($new_pass)) {
        $hashed_pass = password_hash($new_pass, PASSWORD_DEFAULT);
        $stmt = $mysqli->prepare('UPDATE users SET password=? WHERE id=?');
        $stmt->bind_param('si', $hashed_pass, $id);
        $stmt->execute();
    }

    // Update main info
    $stmt = $mysqli->prepare('UPDATE users SET brand_name=?, category=?, location=?, phone=?, email=? WHERE id=?');
    $stmt->bind_param('sssssi', $brand, $cat, $loc, $phone, $email, $id);
    
    if ($stmt->execute()) {
        $msg = '✅ Profile updated successfully!';
        $user = $mysqli->query("SELECT * FROM users WHERE id=$id")->fetch_assoc(); // Refresh user data
    } else {
        $msg = '❌ Error updating profile.';
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Edit Profile - ShopGRL</title>
<style>
    body {
        font-family: 'Poppins', sans-serif;
        background: #f9f9f9;
        color: #222;
        display: flex;
        justify-content: center;
        align-items: center;
        min-height: 100vh;
    }
    .container {
        background: #fff;
        padding: 2rem;
        border-radius: 12px;
        box-shadow: 0 3px 10px rgba(0,0,0,0.1);
        width: 350px;
    }
    h2 {
        color: #b8860b;
        text-align: center;
    }
    label {
        display: block;
        margin-top: 10px;
        font-weight: 600;
    }
    input {
        width: 100%;
        padding: 0.7rem;
        margin-top: 5px;
        border: 1px solid #ccc;
        border-radius: 8px;
    }
    button {
        margin-top: 1rem;
        width: 100%;
        padding: 0.8rem;
        background: linear-gradient(90deg, #1f1f1f, #b8860b);
        color: #fff;
        font-weight: 600;
        border: none;
        border-radius: 8px;
        cursor: pointer;
        transition: all 0.3s ease;
    }
    button:hover {
        background: linear-gradient(90deg, #b8860b, #1f1f1f);
    }
    .msg {
        text-align: center;
        margin-bottom: 1rem;
        color: green;
        font-weight: 500;
    }
    .shop-link {
        text-align: center;
        background: #f4f4f4;
        padding: 0.7rem;
        border-radius: 8px;
        margin-bottom: 1rem;
    }
    .shop-link a {
        color: #000;
        font-weight: 700;
        text-decoration: none;
    }
    .shop-link a:hover {
        color: #b8860b;
    }
</style>
</head>
<body>

<div class="container">
    <h2>Edit Profile</h2>
    <?php if($msg): ?>
        <p class="msg"><?= htmlspecialchars($msg) ?></p>
    <?php endif; ?>

    <!-- 🛍️ Display Shop Link -->
    <div class="shop-link">
        <span>Your Shop Link:</span><br>
        <a href="<?= htmlspecialchars($user['shop_link']) ?>" target="_blank">
            <?= htmlspecialchars($user['shop_link']) ?>
        </a>
    </div>

    <form method="post">
        <label>Brand Name</label>
        <input type="text" name="brand_name" value="<?= htmlspecialchars($user['brand_name']) ?>" required>

        <label>Category</label>
        <input type="text" name="category" value="<?= htmlspecialchars($user['category']) ?>" required>

        <label>Location</label>
        <input type="text" name="location" value="<?= htmlspecialchars($user['location']) ?>" required>

        <label>Phone</label>
        <input type="text" name="phone" value="<?= htmlspecialchars($user['phone']) ?>" required>

        <label>Email</label>
        <input type="email" name="email" value="<?= htmlspecialchars($user['email']) ?>" required>

        <label>Change Password (optional)</label>
        <input type="password" name="new_password" placeholder="Enter new password">

        <button type="submit">Update Profile</button>
    </form>
</div>

</body>
</html>
