<?php
require 'config.php';

$q = $_GET['q'] ?? '';
$category = $_GET['category'] ?? '';

$sql = "SELECT p.*, u.brand_name FROM products p JOIN users u ON p.user_id=u.id WHERE 1 ";
$params = [];
$types = "";

if($q){
    $sql .= " AND p.name LIKE ? ";
    $params[] = "%$q%";
    $types .= "s";
}

if($category){
    $sql .= " AND p.category=? ";
    $params[] = $category;
    $types .= "s";
}

$sql .= " ORDER BY p.created_at DESC";

$stmt = $mysqli->prepare($sql);
if($params){
    $stmt->bind_param($types, ...$params);
}
$stmt->execute();
$result = $stmt->get_result();

$base_url = (strpos($_SERVER['HTTP_HOST'], 'localhost') !== false)
    ? 'http://localhost/GRL/'
    : 'https://' . $_SERVER['HTTP_HOST'] . '/';

while($p = $result->fetch_assoc()){
    echo '<div class="card">
            <img src="'.$base_url.'uploads/'.htmlspecialchars($p['image']).'" alt="Product">
            <h3>'.htmlspecialchars($p['name']).'</h3>
            <p><strong>Brand:</strong> '.htmlspecialchars($p['brand_name']).'</p>
            <p><strong>Price:</strong> $'.htmlspecialchars($p['price']).'</p>
            <p>'.htmlspecialchars($p['description']).'</p>
            <button onclick="alert(\'Redirect to Buy Now / Modal\')">🛒 Buy Now</button>
          </div>';
}
?>
