<?php
header('Content-Type: application/json');
require 'config.php';

$q = isset($_GET['q']) ? trim($_GET['q']) : '';
$category = isset($_GET['category']) ? trim($_GET['category']) : '';
$limit = isset($_GET['limit']) ? (int)$_GET['limit'] : 50;

$sql = "SELECT id, name, description, price, image FROM products";
$clauses = [];
$params = [];
$types = '';

if ($q !== '') {
    $clauses[] = "(name LIKE CONCAT('%', ?, '%') OR description LIKE CONCAT('%', ?, '%'))";
    $types .= 'ss';
    $params[] = $q;
    $params[] = $q;
}

if ($category !== '' && $category !== 'All') {
    $clauses[] = "category = ?";
    $types .= 's';
    $params[] = $category;
}

if (count($clauses) > 0) {
    $sql .= " WHERE " . implode(' AND ', $clauses);
}

$sql .= " ORDER BY id DESC LIMIT ?";
$types .= 'i';
$params[] = $limit;

$stmt = $mysqli->prepare($sql);
if ($types !== '') {
    $bind = [$types];
    foreach ($params as $p) $bind[] = &$p;
    call_user_func_array([$stmt, 'bind_param'], $bind);
}
$stmt->execute();
$res = $stmt->get_result();

$products = [];
while ($row = $res->fetch_assoc()) {
    $row['image_url'] = 'uploads/' . $row['image'];
    $row['currency'] = '¢';
    $row['rating'] = rand(4,5); // Optional: mock rating if not stored
    $products[] = $row;
}

echo json_encode(['products' => $products]);
