<?php
require 'config.php';
$msg = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = $_POST['email'];
    $password = $_POST['password'];

    $stmt = $mysqli->prepare('SELECT id, password FROM users WHERE email=?');
    $stmt->bind_param('s', $email);
    $stmt->execute();
    $res = $stmt->get_result();
    $user = $res->fetch_assoc();

    if ($user && password_verify($password, $user['password'])) {
        $_SESSION['user_id'] = $user['id'];
        header('Location: dashboard.php');
        exit;
    } else {
        $msg = 'Invalid login credentials';
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>ShopGRL | Login</title>
  <style>
    * {
      margin: 0; padding: 0;
      box-sizing: border-box;
      font-family: "Poppins", sans-serif;
    }

    body {
      background: linear-gradient(135deg, #b8860b, #d4af37);
      display: flex;
      justify-content: center;
      align-items: center;
      height: 100vh;
      color: #333;
    }

    .login-container {
      background: #fff;
      padding: 2.5rem;
      border-radius: 15px;
      box-shadow: 0 8px 25px rgba(0,0,0,0.15);
      width: 90%;
      max-width: 400px;
      text-align: center;
      animation: fadeIn 0.6s ease;
      position: relative;
    }

    @keyframes fadeIn {
      from {opacity: 0; transform: translateY(20px);}
      to {opacity: 1; transform: translateY(0);}
    }

    .logo {
      font-size: 2rem;
      font-weight: 800;
      color: #b8860b;
      letter-spacing: 1px;
      margin-bottom: 1.2rem;
    }

    .logo span {
      color: #111;
    }

    h2 {
      color: #444;
      margin-bottom: 1rem;
      font-size: 1.4rem;
    }

    form {
      display: flex;
      flex-direction: column;
      gap: 15px;
    }

    input {
      padding: 12px 14px;
      border-radius: 8px;
      border: 1px solid #ccc;
      font-size: 0.95rem;
      outline: none;
      transition: 0.3s;
    }

    input:focus {
      border-color: #b8860b;
      box-shadow: 0 0 5px rgba(184, 134, 11, 0.4);
    }

    .password-wrapper {
      position: relative;
    }

    .toggle-password {
      position: absolute;
      top: 50%;
      right: 12px;
      transform: translateY(-50%);
      cursor: pointer;
      color: #b8860b;
      font-size: 1.1rem;
    }

    button {
      background: linear-gradient(135deg, #d4af37, #b8860b);
      color: #fff;
      border: none;
      padding: 12px;
      border-radius: 8px;
      font-size: 1rem;
      font-weight: 600;
      cursor: pointer;
      transition: 0.3s;
    }

    button:hover {
      transform: scale(1.05);
      background: linear-gradient(135deg, #b8860b, #d4af37);
    }

    p.message {
      margin-top: 1rem;
      color: #d00;
      font-weight: 500;
    }

    .footer {
      margin-top: 1rem;
      font-size: 0.85rem;
      color: #666;
    }

    .footer a {
      color: #b8860b;
      text-decoration: none;
      font-weight: 600;
    }

    .footer a:hover {
      text-decoration: underline;
    }

    .back-home {
      position: absolute;
      top: 15px;
      right: 15px;
      font-size: 0.9rem;
      text-decoration: none;
      color: #b8860b;
      font-weight: 600;
      transition: 0.3s;
    }

    .back-home:hover {
      text-decoration: underline;
    }
  </style>
</head>
<body>

  <div class="login-container">
    <a href="index.php" class="back-home">← Back Home</a>
    <div class="logo">Shop<span>GRL</span></div>
    <h2>Welcome Back 👋</h2>
    <form method="post">
      <input type="email" name="email" placeholder="Email" required>

      <div class="password-wrapper">
        <input type="password" id="password" name="password" placeholder="Password" required>
        <span class="toggle-password" onclick="togglePassword()">👁️</span>
      </div>

      <button type="submit">Login</button>
    </form>

    <?php if ($msg): ?>
      <p class="message"><?= htmlspecialchars($msg) ?></p>
    <?php endif; ?>

    <div class="footer">
      <p>Don’t have an account? <a href="register.php">Sign Up</a></p>
      <p style="margin-top:8px;font-size:0.8rem;color:#999;">Developed by <strong style="color:#b8860b;">Gen(I)</strong></p>
    </div>
  </div>

  <script>
    function togglePassword() {
      const pass = document.getElementById("password");
      pass.type = pass.type === "password" ? "text" : "password";
    }
  </script>
</body>
</html>
