<?php
require 'config.php';
// session_start(); // Remove if already started in config.php

// Check if vendor is logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

// Vendor info
$vendor_id = $_SESSION['user_id'];
$vendor_stmt = $mysqli->prepare("SELECT brand_name, phone FROM users WHERE id = ?");
$vendor_stmt->bind_param("i", $vendor_id);
$vendor_stmt->execute();
$vendor_result = $vendor_stmt->get_result();
if ($vendor_result && $vendor_result->num_rows > 0) {
    $vendor = $vendor_result->fetch_assoc();
    $vendor_brand = $vendor['brand_name'];
    $vendor_phone = $vendor['phone'];
} else {
    die("⚠️ Something went wrong while fetching your account info.");
}

// Fetch sales
$sales_stmt = $mysqli->prepare("
    SELECT * FROM purchases 
    WHERE brand_name = ? AND seller_phone = ?
    ORDER BY created_at DESC
");
$sales_stmt->bind_param("ss", $vendor_brand, $vendor_phone);
$sales_stmt->execute();
$result = $sales_stmt->get_result();

// Prepare sales array and calculate total commission
$total_commission = 0;
$all_sales = [];
if ($result && $result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $price = isset($row['price']) ? $row['price'] : 0;
        $commission = $price * 0.04;
        $row['commission'] = $commission;
        $total_commission += $commission;
        $all_sales[] = $row;
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>My Sales - ShopGRL</title>
<style>
body { font-family: 'Poppins', sans-serif; margin:0; padding:1rem; background:#f4f4f4; }
.container { max-width: 1000px; margin:auto; background:#fff; padding:1.5rem; border-radius:12px; box-shadow:0 4px 20px rgba(0,0,0,0.1); }
h2 { text-align:center; color:#b8860b; margin-bottom:0.5rem; }
.message-box { background:#fff3cd; border-left:5px solid #ffc107; padding:1rem; border-radius:8px; margin-bottom:1rem; font-weight:600; position:relative; }
.message-box span.close { position:absolute; top:0.2rem; right:0.5rem; cursor:pointer; font-weight:bold; color:#856404; }
.summary { background:#e2f0d9; border-left:5px solid #28a745; padding:1rem; margin-bottom:1rem; border-radius:8px; font-weight:600; }
table { width:100%; border-collapse:collapse; margin-top:1rem; }
th, td { padding:0.75rem; border:1px solid #ddd; text-align:left; }
th { background:#b8860b; color:#fff; text-transform:uppercase; letter-spacing:0.5px; position:sticky; top:0; z-index:1; }
tr:nth-child(even){ background:#f9f9f9; }
tr:hover{ background:#fff3cd; transition:0.2s; }
.commission{ color:#d9534f; font-weight:bold; }
.back-btn { display:inline-block; margin-top:1rem; padding:0.5rem 1rem; background:#b8860b; color:#fff; text-decoration:none; border-radius:5px; font-weight:600; }
.back-btn:hover{ background:#1f1f1f; }
@media(max-width:768px){ table, th, td{ font-size:0.85rem; } .back-btn{ padding:0.4rem 0.8rem; font-size:0.85rem; } }
</style>
</head>
<body>

<div class="container">
    <h2>💰 My Sales Dashboard</h2>

    <!-- Message Box -->
    <div class="message-box" id="msgBox">
        Reminder: You must pay <strong>4% commission per sale</strong> at the end of every month. 
        <span class="close" onclick="closeMsg()">&times;</span>
    </div>

    <!-- Summary -->
    <div class="summary">
        Total Sales: <strong><?= count($all_sales) ?></strong> |
        Total Commission Due: <span class="commission">₵<?= number_format($total_commission,2) ?></span>
    </div>

    <!-- Sales Table -->
    <table>
        <tr>
            <th>Buyer Name</th>
            <th>Buyer Phone</th>
            <th>Product</th>
            <th>Price (₵)</th>
            <th>Location</th>
            <th>Date</th>
            <th>Commission (₵)</th>
        </tr>
        <?php if (!empty($all_sales)): ?>
            <?php foreach($all_sales as $row): ?>
            <tr>
                <td><?= htmlspecialchars($row['buyer_name']) ?></td>
                <td><?= htmlspecialchars($row['buyer_phone']) ?></td>
                <td><?= htmlspecialchars($row['product_name']) ?></td>
                <td><?= isset($row['price']) ? number_format($row['price'],2) : 'N/A' ?></td>
                <td><?= htmlspecialchars($row['buyer_location']) ?></td>
                <td><?= htmlspecialchars($row['created_at']) ?></td>
                <td class="commission"><?= number_format($row['commission'],2) ?></td>
            </tr>
            <?php endforeach; ?>
        <?php else: ?>
            <tr><td colspan="7" style="text-align:center;">No sales yet.</td></tr>
        <?php endif; ?>
    </table>

    <a href="dashboard.php" class="back-btn">🏠 Back to Home</a>
</div>

<script>
function closeMsg(){
    document.getElementById('msgBox').style.display='none';
}

// Auto hide message after 5 seconds
window.onload = function(){
    setTimeout(() => {
        const msg = document.getElementById('msgBox');
        if(msg) msg.style.display = 'none';
    }, 5000);
}
</script>

</body>
</html>
