<?php
require 'config.php';
if (session_status() === PHP_SESSION_NONE) session_start();

// Ensure vendor is logged in
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$vendor_id = $_SESSION['user_id'];

// Fetch vendor info
$vendor_query = $mysqli->prepare("SELECT brand_name, phone FROM users WHERE id = ?");
$vendor_query->bind_param("i", $vendor_id);
$vendor_query->execute();
$vendor_result = $vendor_query->get_result();
$vendor = $vendor_result->fetch_assoc();

$seller_phone = $vendor['phone'] ?? '';
$brand_name = $vendor['brand_name'] ?? '';

// Fetch sales (purchases where this vendor was the seller)
$sql = "SELECT buyer_name, buyer_phone, buyer_location, product_name, created_at, p.price
        FROM purchases pur
        JOIN products p ON pur.product_name = p.name
        WHERE pur.seller_phone = ?
        ORDER BY pur.created_at DESC";

$stmt = $mysqli->prepare($sql);
$stmt->bind_param("s", $seller_phone);
$stmt->execute();
$sales = $stmt->get_result();

// Calculate totals
$total_sales = $sales->num_rows;
$total_amount = 0;
while ($row = $sales->fetch_assoc()) {
    $total_amount += $row['price'];
    $sales_data[] = $row;
}
$total_commission = $total_amount * 0.04; // 4% commission
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>My Sales - ShopGRL</title>
  <link rel="stylesheet" href="style.css?v=<?php echo time(); ?>">
  <style>
    body {
      font-family: 'Poppins', sans-serif;
      background: #fafafa;
      margin: 0;
      padding: 0;
    }
    header {
      background: #111;
      color: #fff;
      text-align: center;
      padding: 1rem;
    }
    .sales-container {
      max-width: 900px;
      margin: 2rem auto;
      background: #fff;
      border-radius: 12px;
      box-shadow: 0 2px 8px rgba(0,0,0,0.1);
      padding: 1rem 1.5rem;
    }
    .sales-container h2 {
      text-align: center;
      color: #d4af37;
    }
    .summary {
      background: #f9f9f9;
      border: 1px solid #eee;
      border-radius: 10px;
      padding: 1rem;
      margin-bottom: 1rem;
    }
    .summary h3 {
      margin-top: 0;
      color: #111;
    }
    .summary p {
      margin: 4px 0;
      font-size: 0.95rem;
    }
    .summary strong {
      color: #d4af37;
    }
    table {
      width: 100%;
      border-collapse: collapse;
      margin-top: 1rem;
    }
    th, td {
      padding: 12px;
      border-bottom: 1px solid #ddd;
      text-align: left;
    }
    th {
      background: #f5f5f5;
      color: #333;
    }
    tr:hover {
      background: #f9f9f9;
    }
    .no-sales {
      text-align: center;
      padding: 1rem;
      color: #777;
    }
    .back-btn {
      display: inline-block;
      background: #ffd700;
      color: #111;
      padding: 10px 18px;
      border-radius: 8px;
      text-decoration: none;
      font-weight: 600;
      transition: 0.3s;
      margin-bottom: 10px;
    }
    .back-btn:hover {
      background: #ffcc00;
      transform: scale(1.05);
    }
    @media (max-width: 600px) {
      table, thead, tbody, th, td, tr {
        display: block;
      }
      tr {
        margin-bottom: 1rem;
        background: #fdfdfd;
        border-radius: 8px;
        box-shadow: 0 1px 4px rgba(0,0,0,0.1);
      }
      td {
        padding: 8px 12px;
        border: none;
      }
      th {
        display: none;
      }
    }
  </style>
</head>
<body>

<header>
  <h1>📊 My Sales Dashboard</h1>
</header>

<div class="sales-container">
  <a href="dashboard.php" class="back-btn">⬅️ Back to Home</a>
  <h2>Sales for <?= htmlspecialchars($brand_name) ?></h2>

  <div class="summary">
    <h3>💰 Sales Summary</h3>
    <p><strong>Total Sales:</strong> <?= $total_sales ?></p>
    <p><strong>Total Amount Sold:</strong> ₵<?= number_format($total_amount, 2) ?></p>
    <p><strong>Commission (4%):</strong> ₵<?= number_format($total_commission, 2) ?></p>
    <p style="margin-top:10px; font-size:0.9rem; color:#555;">
      ⚠️ <strong>Note:</strong> You are required to pay the total commission of 
      <strong>₵<?= number_format($total_commission, 2) ?></strong> to ShopGRL at the end of each month.
    </p>
  </div>

  <?php if (!empty($sales_data)): ?>
    <table>
      <thead>
        <tr>
          <th>Product</th>
          <th>Buyer</th>
          <th>Phone</th>
          <th>Location</th>
          <th>Price (₵)</th>
          <th>Date</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($sales_data as $row): ?>
        <tr>
          <td><?= htmlspecialchars($row['product_name']) ?></td>
          <td><?= htmlspecialchars($row['buyer_name']) ?></td>
          <td><?= htmlspecialchars($row['buyer_phone']) ?></td>
          <td><?= htmlspecialchars($row['buyer_location']) ?></td>
          <td><?= number_format($row['price'], 2) ?></td>
          <td><?= date("M d, Y h:i A", strtotime($row['created_at'])) ?></td>
        </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  <?php else: ?>
    <p class="no-sales">😞 You have no sales yet.</p>
  <?php endif; ?>
</div>

</body>
</html>
