<?php
require 'config.php';
$msg = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $brand = trim($_POST['brand_name']);
    $cat = trim($_POST['category']);
    $loc = trim($_POST['location']);
    $phone = trim($_POST['phone']);
    $email = trim($_POST['email']);
    $pass = $_POST['password'];
    $confirm_pass = $_POST['confirm_password'];

    if ($pass !== $confirm_pass) {
        $msg = "❌ Passwords do not match!";
    } elseif (!preg_match('/^(?=.*[A-Z])(?=.*\d)(?=.*[!@#$%^&*]).{8,}$/', $pass)) {
        $msg = "⚠️ Password must be at least 8 characters, include an uppercase letter, number, and symbol.";
    } else {
        $check = $mysqli->prepare("SELECT id FROM users WHERE email = ?");
        $check->bind_param("s", $email);
        $check->execute();
        $check->store_result();

        if ($check->num_rows > 0) {
            $msg = "❌ Email already registered. Try logging in.";
        } else {
            $slug = strtolower(preg_replace('/[^a-z0-9]+/', '-', $brand));
            $base_url = (strpos($_SERVER['HTTP_HOST'], 'localhost') !== false)
                ? 'http://localhost/GRL/'
                : 'https://' . $_SERVER['HTTP_HOST'] . '/';
            $shop_link = $base_url . 'shop/' . $slug;

            $hashed_pass = password_hash($pass, PASSWORD_DEFAULT);

            $stmt = $mysqli->prepare('INSERT INTO users (brand_name, shop_link, category, location, phone, email, password) VALUES (?, ?, ?, ?, ?, ?, ?)');
            if ($stmt) {
                $stmt->bind_param('sssssss', $brand, $shop_link, $cat, $loc, $phone, $email, $hashed_pass);
                if ($stmt->execute()) {
                    header('Location: login.php');
                    exit;
                } else {
                    $msg = '❌ Registration failed. Please try again.';
                }
            } else {
                $msg = '❌ Database error. Check your table columns.';
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Vendor Registration - ShopGRL</title>
<style>
    body {
        font-family: 'Poppins', sans-serif;
        background: #f4f4f4;
        margin: 0;
        display: flex;
        justify-content: center;
        align-items: center;
        min-height: 100vh;
        padding: 1rem;
    }
    form {
        background: #fff;
        padding: 2rem;
        border-radius: 12px;
        box-shadow: 0 4px 15px rgba(0,0,0,0.15);
        max-width: 400px;
        width: 100%;
    }
    h2 {
        color: #b8860b;
        text-align: center;
        margin-bottom: 0.5rem;
    }
    .vendor-note {
        text-align: center;
        font-size: 0.85rem;
        color: #666;
        margin-bottom: 1rem;
    }
    input {
        width: 100%;
        padding: 0.75rem;
        margin: 0.5rem 0;
        border: 1px solid #ccc;
        border-radius: 8px;
        font-size: 0.95rem;
    }
    button {
        width: 100%;
        padding: 0.9rem;
        background: linear-gradient(90deg, #1f1f1f, #b8860b);
        color: #fff;
        font-weight: 600;
        border: none;
        border-radius: 8px;
        cursor: pointer;
        font-size: 1rem;
        margin-top: 0.5rem;
        transition: 0.3s ease;
    }
    button:hover {
        background: linear-gradient(90deg, #b8860b, #1f1f1f);
    }
    p.msg {
        text-align: center;
        color: red;
        font-size: 0.9rem;
        margin-bottom: 0.5rem;
    }
    .hint {
        color: #666;
        font-size: 0.8rem;
        margin-bottom: 0.5rem;
    }

    /* Responsive adjustments */
    @media (max-width: 500px) {
        form {
            padding: 1.5rem;
        }
        input, button {
            font-size: 0.9rem;
        }
    }
</style>
</head>
<body>
<form method="post">
    <h2>Vendor Registration</h2>
    <div class="vendor-note">This registration form is only for vendors.</div>
    
    <p class="msg"><?= htmlspecialchars($msg) ?></p>
    
    <!-- ShopGRL Branding -->
    <div style="text-align:center; margin-bottom:1rem;">
        <a href="index.php" style="text-decoration:none; font-weight:bold; color:#b8860b; font-size:1.2rem;">
            Shop<span style="color:#1f1f1f;">GRL</span>
        </a>
    </div>

    <!-- Form Fields -->
    <input type="text" name="brand_name" placeholder="Brand Name" required>
    <input type="text" name="category" placeholder="Category" required>
    <input type="text" name="location" placeholder="Location" required>
    <input type="text" name="phone" placeholder="Phone" required>
    <input type="email" name="email" placeholder="Email" required>

    <div class="hint">Password must be at least 8 characters, include a number, uppercase letter, and symbol.</div>
    <input type="password" name="password" placeholder="Password" required>
    <input type="password" name="confirm_password" placeholder="Confirm Password" required>

    <button type="submit">Register</button>

    <!-- Sign In Link -->
    <div style="text-align:center; margin-top:1rem; font-size:0.9rem;">
        Already have an account? 
        <a href="login.php" style="color:#b8860b; text-decoration:none; font-weight:bold;">Sign In</a>
    </div>
</form>

</body>
</html>
