const grid = document.getElementById('productGrid');
const searchInput = document.getElementById('searchInput');
const searchBtn = document.getElementById('searchBtn');
const catBtns = document.querySelectorAll('.cat');

let currentCat = 'All';
let searchTerm = '';

function fetchProducts() {
  const params = new URLSearchParams({q: searchTerm, category: currentCat});
  fetch('get_products.php?' + params.toString())
    .then(r => r.json())
    .then(data => {
      const products = data.products || [];
      if (!products.length) {
        grid.innerHTML = '<p>No products found.</p>';
        return;
      }
      grid.innerHTML = products.map(p => `
        <div class="card">
          <img src="${p.image_url}" alt="${p.name}">
          <div class="name">${p.name}</div>
          <div class="price">¢${Number(p.price).toFixed(2)}</div>
        </div>
      `).join('');
    });
}

searchBtn.addEventListener('click', () => {
  searchTerm = searchInput.value.trim();
  fetchProducts();
});

catBtns.forEach(btn => {
  btn.addEventListener('click', () => {
    catBtns.forEach(b => b.classList.remove('active'));
    btn.classList.add('active');
    currentCat = btn.dataset.cat;
    fetchProducts();
  });
});

fetchProducts();
