<?php
require '../config.php';

$slug = $_GET['slug'] ?? '';
if (!$slug) die("Shop not found");

$stmt = $mysqli->prepare("SELECT * FROM users WHERE LOWER(REPLACE(brand_name,' ', '-')) = ?");
$stmt->bind_param("s", $slug);
$stmt->execute();
$seller = $stmt->get_result()->fetch_assoc();

if (!$seller) die("Shop not found");

$products = $mysqli->query("SELECT * FROM products WHERE user_id = {$seller['id']}");
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title><?= htmlspecialchars($seller['brand_name']) ?> | ShopGRL</title>

<link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">

<style>
:root {
  --gold: #c8a406;
  --gold-light: #f5e6a1;
  --black: #1a1a1a;
  --gray: #eee;
  --white: #fffdf7;
  --radius: 14px;
  --shadow: 0 8px 25px rgba(0,0,0,0.08);
}

body {
  font-family: 'Inter', sans-serif;
  margin: 0;
  background: var(--white);
  color: var(--black);
  line-height: 1.5;
}

/* HEADER */
header.shop-header {
  text-align: center;
  padding: 2.5rem 1rem;
  background: linear-gradient(180deg, #fff, #faf7f0);
  border-bottom: 2px solid var(--gold-light);
  position: sticky;
  top: 0;
  z-index: 10;
  box-shadow: 0 3px 15px rgba(0,0,0,0.05);
}

.shop-header img {
  width: 110px;
  height: 110px;
  border-radius: 50%;
  border: 3px solid var(--gold);
  object-fit: cover;
  transition: transform 0.3s;
}
.shop-header img:hover {
  transform: scale(1.05);
}

.shop-header h2 {
  margin: 1rem 0 0.3rem;
  font-size: 1.8rem;
  color: var(--black);
}

.verified-badge {
  display: inline-flex;
  align-items: center;
  background: var(--gold-light);
  color: var(--black);
  padding: 4px 10px;
  border-radius: 20px;
  font-size: 0.8rem;
  font-weight: 600;
  margin-left: 6px;
}

.verified-badge img {
  width: 15px;
  height: 15px;
  margin-right: 4px;
}

.shop-header p {
  color: #555;
  font-size: 0.9rem;
}

.shop-actions {
  margin-top: 1.2rem;
  display: flex;
  justify-content: center;
  flex-wrap: wrap;
  gap: 10px;
}

.shop-actions button, .shop-actions a {
  background: var(--black);
  color: var(--gold-light);
  border: none;
  border-radius: var(--radius);
  padding: 10px 18px;
  font-weight: 600;
  cursor: pointer;
  transition: 0.3s;
  text-decoration: none;
  box-shadow: var(--shadow);
}
.shop-actions button:hover, .shop-actions a:hover {
  background: var(--gold);
  color: var(--black);
}

/* PRODUCT GRID */
section.grid {
  padding: 2rem;
  display: grid;
  gap: 1.8rem;
  grid-template-columns: repeat(auto-fill, minmax(250px, 1fr));
}

.product-card {
  background: #fff;
  border-radius: var(--radius);
  border: 1px solid #f0f0f0;
  box-shadow: var(--shadow);
  overflow: hidden;
  transition: transform 0.3s ease, box-shadow 0.3s ease;
}
.product-card:hover {
  transform: translateY(-5px);
  box-shadow: 0 12px 30px rgba(0,0,0,0.12);
}

.product-card img {
  width: 100%;
  height: 200px;
  object-fit: cover;
  border-bottom: 2px solid var(--gold-light);
}

.product-card .info {
  padding: 1rem;
  text-align: center;
}

.product-card h3 {
  font-size: 1.05rem;
  margin: 0.5rem 0;
  color: var(--black);
}
.product-card p {
  color: #666;
  font-size: 0.9rem;
  min-height: 38px;
}

.product-card .price {
  color: var(--gold);
  font-weight: 700;
  font-size: 1.1rem;
  margin: 0.5rem 0;
}

.actions a {
  display: inline-block;
  background: var(--gold);
  color: var(--black);
  font-weight: 600;
  padding: 8px 14px;
  border-radius: 8px;
  text-decoration: none;
  transition: 0.3s;
}
.actions a:hover {
  background: var(--black);
  color: var(--gold-light);
}

/* FLOATING HOME BUTTON */
.floating-home {
  position: fixed;
  bottom: 20px;
  right: 20px;
  background: var(--black);
  color: var(--gold-light);
  border: none;
  border-radius: 50%;
  width: 55px;
  height: 55px;
  font-size: 1.4rem;
  display: flex;
  justify-content: center;
  align-items: center;
  box-shadow: 0 8px 20px rgba(0,0,0,0.25);
  cursor: pointer;
  transition: 0.3s;
  text-decoration: none;
}
.floating-home:hover {
  background: var(--gold);
  color: var(--black);
  transform: scale(1.1);
}

/* RESPONSIVE */
@media (max-width: 650px) {
  header.shop-header { padding: 2rem 1rem; }
  .shop-header img { width: 90px; height: 90px; }
  section.grid { padding: 1rem; gap: 1.2rem; }
}
</style>
</head>
<body>

<header class="shop-header">
  
  <h2>
    <?= htmlspecialchars($seller['brand_name']) ?>
    <?php if (!empty($seller['is_verified']) && $seller['is_verified'] == 1): ?>
      <span class="verified-badge">
        <img src="shopgrl.jpeg" alt="Verified"> Verified
      </span>
    <?php endif; ?>
  </h2>
  <p>📍 <?= htmlspecialchars($seller['location']) ?> | 📞 <?= htmlspecialchars($seller['phone']) ?></p>

  <div class="shop-actions">
    <button onclick="shareShop()">Share Shop</button>
  </div>
</header>

<section class="grid">
<?php if ($products->num_rows > 0): ?>
  <?php while($p = $products->fetch_assoc()): ?>
  <div class="product-card">
    <img src="../uploads/<?= htmlspecialchars($p['image']) ?>" alt="<?= htmlspecialchars($p['name']) ?>">
    <div class="info">
      <h3><?= htmlspecialchars($p['name']) ?></h3>
      <p><?= htmlspecialchars($p['description']) ?></p>
      <div class="price">₵<?= number_format($p['price'], 2) ?></div>
      <div class="actions">
        <a href="../index.php?buy=<?= urlencode($p['id']) ?>">🛍 Buy Now</a>
      </div>
    </div>
  </div>
  <?php endwhile; ?>
<?php else: ?>
  <p style="text-align:center;">No products available yet.</p>
<?php endif; ?>
</section>

<a href="../index.php" class="floating-home" title="Back to Home">🏠</a>

<script>
function shareShop() {
  const link = window.location.href;
  if (navigator.share) {
    navigator.share({
      title: "ShopGRL Seller",
      text: "Check out this amazing shop on ShopGRL!",
      url: link
    });
  } else {
    navigator.clipboard.writeText(link);
    alert("✅ Shop link copied to clipboard!");
  }
}
</script>

</body>
</html>
