<?php
header('Content-Type: application/xml; charset=utf-8');
require 'config.php';

// Base URL
$base_url = "https://its-insight.com/";

// XML header
echo '<?xml version="1.0" encoding="UTF-8"?>' . "\n";
echo '<urlset xmlns="https://www.sitemaps.org/schemas/sitemap/0.9"
        xmlns:image="https://www.google.com/schemas/sitemap-image/1.1">' . "\n";

// ------------------------
// Homepage
// ------------------------
echo "<url>\n";
echo "<loc>{$base_url}</loc>\n";
echo "<priority>1.0</priority>\n";
echo "<changefreq>daily</changefreq>\n";
echo "</url>\n";

// ------------------------
// Categories
// ------------------------
$catRes = $mysqli->query("SELECT DISTINCT category FROM products WHERE category IS NOT NULL AND category <> ''");
while ($cat = $catRes->fetch_assoc()) {
    $cat_url = $base_url . 'index.php?category=' . urlencode($cat['category']);
    echo "<url>\n";
    echo "<loc>{$cat_url}</loc>\n";
    echo "<priority>0.8</priority>\n";
    echo "<changefreq>weekly</changefreq>\n";
    echo "</url>\n";
}

// ------------------------
// Products
// ------------------------
$productRes = $mysqli->query("SELECT id, name, image, updated_at, created_at FROM products");
while ($p = $productRes->fetch_assoc()) {
    $prod_url = $base_url . 'product.php?id=' . $p['id'];
    $lastmod = !empty($p['updated_at']) ? $p['updated_at'] : $p['created_at'];
    echo "<url>\n";
    echo "<loc>{$prod_url}</loc>\n";
    echo "<lastmod>" . date('Y-m-d', strtotime($lastmod)) . "</lastmod>\n";
    echo "<priority>0.9</priority>\n";
    echo "<changefreq>weekly</changefreq>\n";

    // Add image if exists
    if (!empty($p['image'])) {
        $img_url = $base_url . 'uploads/' . $p['image'];
        echo "<image:image>\n";
        echo "<image:loc>{$img_url}</image:loc>\n";
        echo "<image:title>" . htmlspecialchars($p['name']) . "</image:title>\n";
        echo "</image:image>\n";
    }

    echo "</url>\n";
}

echo '</urlset>';
?>
