<?php
require 'config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['id'], $_POST['action'])) {
    $id = intval($_POST['id']);
    $action = $_POST['action'] === 'approve' ? 'approved' : 'rejected';

    // ✅ Use prepared statement to safely fetch email
    $stmt = $mysqli->prepare("SELECT email FROM verification_requests WHERE id = ?");
    $stmt->bind_param('i', $id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($req = $result->fetch_assoc()) {
        $email = $req['email'];

        // ✅ Update verification request status
        $updateReq = $mysqli->prepare("UPDATE verification_requests SET status = ? WHERE id = ?");
        $updateReq->bind_param('si', $action, $id);
        $updateReq->execute();

        // ✅ Update user's verification status
        $is_verified = ($action === 'approved') ? 1 : 0;
        $updateUser = $mysqli->prepare("UPDATE users SET is_verified = ? WHERE email = ?");
        $updateUser->bind_param('is', $is_verified, $email);
        $updateUser->execute();
    }

    header('Location: admin_verify_panel.php?status=' . $action);
    exit;
}
?>
