<?php
require 'config.php';
if (session_status() === PHP_SESSION_NONE) session_start();
$seller_id = $_SESSION['user_id'] ?? 0;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = $_POST['full_name'];
    $email = $_POST['email'];
    $business = $_POST['business_name'];
    $link = $_POST['business_link'];

    $stmt = $mysqli->prepare("INSERT INTO verification_requests (seller_id, full_name, email, business_name, business_link) VALUES (?, ?, ?, ?, ?)");
    $stmt->bind_param("issss", $seller_id, $name, $email, $business, $link);
    $stmt->execute();
    echo "<script>alert('✅ Your verification request has been sent!');window.location='dashboard.php';</script>";
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Verification Request - ShopGRL</title>

<style>
  body {
    font-family: 'Poppins', sans-serif;
    background: linear-gradient(135deg, #f9f9f9, #ececec);
    display: flex;
    justify-content: center;
    align-items: center;
    height: 100vh;
    margin: 0;
  }

  .verify-wrapper {
    display: flex;
    justify-content: center;
    align-items: center;
    width: 100%;
    padding: 1rem;
  }

  .verify-container {
    background: #fff;
    padding: 2rem 2.5rem;
    border-radius: 15px;
    box-shadow: 0 5px 18px rgba(0, 0, 0, 0.1);
    width: 100%;
    max-width: 400px;
    text-align: center;
  }

  .verify-brand {
    font-size: 1.8rem;
    font-weight: 700;
    color: #b8860b;
    margin-bottom: 0.5rem;
  }

  .verify-brand span {
    color: #111;
  }

  h2 {
    color: #1f1f1f;
    font-size: 1.4rem;
    margin-bottom: 1rem;
  }

  form {
    display: flex;
    flex-direction: column;
    gap: 0.9rem;
  }

  input {
    width: 100%;
    padding: 0.85rem;
    border: 1px solid #ccc;
    border-radius: 8px;
    font-size: 0.95rem;
    transition: all 0.3s ease;
  }

  input:focus {
    border-color: #b8860b;
    outline: none;
  }

  button {
    background: linear-gradient(90deg, #1f1f1f, #b8860b);
    color: white;
    font-weight: 600;
    border: none;
    padding: 0.9rem;
    border-radius: 8px;
    cursor: pointer;
    transition: all 0.3s ease;
  }

  button:hover {
    background: linear-gradient(90deg, #b8860b, #1f1f1f);
    transform: scale(1.03);
  }

  @media (max-width: 480px) {
    .verify-container {
      width: 100%;
      padding: 1.5rem;
    }
    .verify-brand {
      font-size: 1.5rem;
    }
    h2 {
      font-size: 1.2rem;
    }
  }
</style>
</head>
<body>

<div class="verify-wrapper">
  <div class="verify-container">
    <div class="verify-brand">Shop<span>GRL</span></div>
    <h2>Request Verification</h2>
    <form method="POST">
      <input type="text" name="full_name" placeholder="Full Name" required>
      <input type="email" name="email" placeholder="Email" required>
      <input type="text" name="business_name" placeholder="Business Name" required>
      <input type="url" name="business_link" placeholder="Your ShopGRL Store Link" required>
      <button type="submit">Submit Request</button>
    </form>
  </div>
</div>

</body>
</html>
