<?php
require 'config.php';

// Fetch themes
$themes = $pdo->query("SELECT DISTINCT theme FROM quotes")->fetchAll(PDO::FETCH_COLUMN);
$selectedThemes = $_GET['themes'] ?? [];
if(!is_array($selectedThemes)) $selectedThemes = [$selectedThemes];
$selectedThemes = array_slice($selectedThemes,0,4); // max 4

// Fetch quotes not used in multi-post
if(count($selectedThemes)>0){
    $placeholders = implode(',', array_fill(0,count($selectedThemes),'?'));
    $stmt = $pdo->prepare("SELECT * FROM quotes WHERE theme IN ($placeholders) AND used_multi=0 ORDER BY id ASC");
    $stmt->execute($selectedThemes);
}else{
    $stmt = $pdo->query("SELECT * FROM quotes WHERE used_multi=0 ORDER BY id ASC");
}
$quotes = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Popular hashtags
$popular_hashtags = ['motivation','success','inspiration','mindset','goals','life','dreambig','growth','entrepreneur','hustle'];

// Function to render quote image
function renderQuoteImage($quoteText,$author,$theme){
    $baseImage = fetchUnsplashImage($theme);
    $img = @imagecreatefromjpeg($baseImage);
    if(!$img){
        $img=imagecreatetruecolor(800,800);
        $bg=imagecolorallocate($img,50,50,50);
        imagefill($img,0,0,$bg);
    }
    $white=imagecolorallocate($img,255,255,255);
    $fontPath=__DIR__.'/fonts/OpenSans-Bold.ttf';
    $fontSize=24;

    $lines=[]; $words=explode(" ",$quoteText); $line="";
    foreach($words as $word){
        if(strlen($line." ".$word)>40){ $lines[]=$line; $line=$word; }else{ $line.=($line==""?"":" ").$word; }
    }
    $lines[]=$line;

    $y=100;
    foreach($lines as $line){
        imagettftext($img,$fontSize,0,30,$y,$white,$fontPath,$line);
        $y+=$fontSize+10;
    }
    imagettftext($img,18,0,30,$y+20,$white,$fontPath,"- $author");

    if(!is_dir('tmp')) mkdir('tmp',0777,true);
    $filename='tmp/'.md5($quoteText.time()).'.jpg';
    imagejpeg($img,$filename,90);
    imagedestroy($img);
    return $filename;
}

// Generate images and mark used
foreach($quotes as &$q){
    $q['image_on_text']=renderQuoteImage($q['quote'],$q['author'],$q['theme']);
    $pdo->prepare("UPDATE quotes SET used_multi=1 WHERE id=?")->execute([$q['id']]);
}
unset($q);

// Prepare caption
$combined_caption="";
foreach($quotes as $q){ $combined_caption.='"'.$q['quote'].'" — '.$q['author'].' #'.$q['theme'].' '; }
$combined_caption.='#'.implode(' #',$popular_hashtags);
$caption_url=urlencode($combined_caption);
$share_url="https://www.instagram.com/create/select/?caption=$caption_url";
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>Multi-Quote Dashboard</title>
<style>
body{font-family:system-ui,sans-serif;background:#f5f5f5;padding:20px;}
.quote-card{background:white;padding:16px;border-radius:12px;margin-bottom:16px;box-shadow:0 2px 8px rgba(0,0,0,0.08);}
img{max-width:100%;border-radius:10px;margin-bottom:10px;}
button{background:#000;color:#fff;border:none;border-radius:8px;padding:10px 20px;cursor:pointer;margin-top:5px;}
.filter{margin-bottom:20px;}
.filter label{margin-right:10px;}
</style>
</head>
<body>

<h2>🪶 Multi-Quote Dashboard</h2>

<form method="get" class="filter">
<strong>Select up to 4 themes:</strong><br>
<?php foreach($themes as $theme): ?>
<label>
<input type="checkbox" name="themes[]" value="<?= htmlspecialchars($theme) ?>" <?= in_array($theme,$selectedThemes)?'checked':'' ?>>
<?= htmlspecialchars($theme) ?>
</label>
<?php endforeach; ?>
<button type="submit">Apply Filter</button>
</form>

<?php if(count($quotes)>0): ?>
<?php foreach($quotes as $q): ?>
<div class="quote-card">
<img src="<?= $q['image_on_text'] ?>" alt="<?= htmlspecialchars($q['theme']) ?>">
<p><strong>"<?= htmlspecialchars($q['quote']) ?>"</strong></p>
<p>— <?= htmlspecialchars($q['author']) ?> (#<?= htmlspecialchars($q['theme']) ?>)</p>
<a href="<?= $share_url ?>" target="_blank">
<button>📲 Share Selected Quotes</button>
</a>
</div>
<?php endforeach; ?>
<?php else: ?>
<p>All quotes for selected themes have been posted. Reset or add new quotes.</p>
<?php endif; ?>

</body>
</html>
