<?php
require 'config.php';

if(isset($_POST['submit']) && isset($_FILES['csv_file'])){
    $file = $_FILES['csv_file']['tmp_name'];
    if(($handle = fopen($file, "r")) !== FALSE){
        $quotes = [];
        while(($data = fgetcsv($handle, 1000, ",")) !== FALSE){
            $quoteText = trim($data[0]);
            $author = trim($data[1]);
            $theme = trim($data[2]);
            if($quoteText && $author && $theme){
                $quotes[] = ['quote'=>$quoteText, 'author'=>$author, 'theme'=>$theme];
            }
        }
        fclose($handle);

        // Insert or update
        foreach($quotes as $q){
            $stmt = $pdo->prepare("SELECT id FROM quotes WHERE quote=? AND theme=?");
            $stmt->execute([$q['quote'], $q['theme']]);
            $existing = $stmt->fetch(PDO::FETCH_ASSOC);

            if($existing){
                $update = $pdo->prepare("UPDATE quotes SET author=?, updated_at=NOW() WHERE id=?");
                $update->execute([$q['author'], $existing['id']]);
            } else {
                $insert = $pdo->prepare("INSERT INTO quotes (quote, author, theme) VALUES (?, ?, ?)");
                $insert->execute([$q['quote'], $q['author'], $q['theme']]);
            }
        }

        // Delete old quotes not in CSV
        $currentQuotes = array_column($quotes, 'quote');
        if(count($currentQuotes) > 0){
            $placeholders = implode(',', array_fill(0, count($currentQuotes), '?'));
            $delete = $pdo->prepare("DELETE FROM quotes WHERE quote NOT IN ($placeholders)");
            $delete->execute($currentQuotes);
        }

        echo "✅ CSV processed successfully! Total quotes: " . count($quotes);
    } else {
        echo "❌ Failed to read CSV file.";
    }
} else {
?>
<form method="post" enctype="multipart/form-data">
    <h2>Upload Quotes CSV</h2>
    <input type="file" name="csv_file" accept=".csv" required>
    <button type="submit" name="submit">Upload & Update DB</button>
</form>
<?php
}
